/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver;

import java.util.Objects;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.executor.MigrationExecutor;
import migratedb.v1.core.api.resolver.ResolvedMigration;

public class ResolvedMigrationImpl
implements ResolvedMigration {
    private final String script;
    private final Checksum equivalentChecksum;
    private final Checksum checksum;
    private final Version version;
    private final String description;
    private final MigrationType type;
    private final String locationDescription;
    private final MigrationExecutor executor;

    public ResolvedMigrationImpl(Version version, String description, String script, Checksum checksum, Checksum equivalentChecksum, MigrationType type, String locationDescription, MigrationExecutor executor) {
        this.version = version;
        this.description = description;
        this.script = script;
        this.checksum = checksum;
        this.equivalentChecksum = equivalentChecksum;
        this.type = type;
        this.locationDescription = locationDescription;
        this.executor = executor;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public Checksum getChecksum() {
        return this.checksum == null ? this.equivalentChecksum : this.checksum;
    }

    @Override
    public MigrationType getType() {
        return this.type;
    }

    @Override
    public String getLocationDescription() {
        return this.locationDescription;
    }

    @Override
    public MigrationExecutor getExecutor() {
        return this.executor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResolvedMigrationImpl)) {
            return false;
        }
        ResolvedMigrationImpl other = (ResolvedMigrationImpl)o;
        return Objects.equals(this.checksum, other.checksum) && Objects.equals(this.equivalentChecksum, other.equivalentChecksum) && Objects.equals(this.description, other.description) && Objects.equals(this.script, other.script) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checksum, this.equivalentChecksum, this.description, this.script, this.type});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{version=" + this.version + ", description='" + this.description + "', script='" + this.script + "', checksum=" + this.getChecksum() + ", type=" + this.type + ", locationDescription='" + this.locationDescription + "', executor=" + this.executor + "}";
    }

    @Override
    public boolean checksumMatches(Checksum checksum) {
        return Objects.equals(checksum, this.checksum) || Objects.equals(checksum, this.equivalentChecksum) && this.equivalentChecksum != null;
    }
}

