/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.resource.Resource;

public final class ChecksumCalculator
extends Enum<ChecksumCalculator> {
    private static final /* synthetic */ ChecksumCalculator[] $VALUES;

    public static ChecksumCalculator[] values() {
        return (ChecksumCalculator[])$VALUES.clone();
    }

    public static ChecksumCalculator valueOf(String name) {
        return Enum.valueOf(ChecksumCalculator.class, name);
    }

    public static Checksum calculate(Collection<Resource> resources, Configuration configuration) {
        ArrayList<Resource> sortedResources = new ArrayList<Resource>(resources);
        sortedResources.sort(Comparator.comparing(Resource::getName));
        Checksum.Builder builder = Checksum.builder();
        for (Resource resource : sortedResources) {
            try {
                Reader reader = resource.read(configuration.getEncoding());
                try {
                    builder.addLines(reader);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new MigrateDbException("Unable to calculate checksum of " + resource.getName() + "\n" + e.getMessage(), e);
            }
        }
        return builder.build();
    }

    private static /* synthetic */ ChecksumCalculator[] $values() {
        return new ChecksumCalculator[0];
    }

    static {
        $VALUES = ChecksumCalculator.$values();
    }
}

