/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.parser;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.resource.ResourceName;
import migratedb.v1.core.api.logging.Log;

public class ParsingContextImpl
implements ParsingContext {
    private static final Log LOG = Log.getLog(ParsingContextImpl.class);
    private static final String DEFAULT_SCHEMA_PLACEHOLDER = "migratedb:defaultSchema";
    private static final String USER_PLACEHOLDER = "migratedb:user";
    private static final String DATABASE_PLACEHOLDER = "migratedb:database";
    private static final String TIMESTAMP_PLACEHOLDER = "migratedb:timestamp";
    private static final String FILENAME_PLACEHOLDER = "migratedb:filename";
    private static final String WORKING_DIRECTORY_PLACEHOLDER = "migratedb:workingDirectory";
    private static final String TABLE_PLACEHOLDER = "migratedb:table";
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private Database database;

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    private void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    public void populate(Database database, Configuration configuration) {
        this.setDatabase(database);
        String defaultSchemaName = configuration.getDefaultSchema();
        List<String> schemaNames = configuration.getSchemas();
        Schema currentSchema = this.getCurrentSchema(database);
        String catalog = database.getCatalog();
        String currentUser = this.getCurrentUser(database);
        if (defaultSchemaName == null) {
            if (!schemaNames.isEmpty()) {
                defaultSchemaName = schemaNames.get(0);
            } else {
                assert (currentSchema != null);
                defaultSchemaName = currentSchema.getName();
            }
        }
        if (defaultSchemaName != null) {
            this.placeholders.put(DEFAULT_SCHEMA_PLACEHOLDER, defaultSchemaName);
        }
        if (catalog != null) {
            this.placeholders.put(DATABASE_PLACEHOLDER, catalog);
        }
        this.placeholders.put(USER_PLACEHOLDER, currentUser);
        this.placeholders.put(TIMESTAMP_PLACEHOLDER, Instant.now().toString());
        this.placeholders.put(WORKING_DIRECTORY_PLACEHOLDER, System.getProperty("user.dir"));
        this.placeholders.put(TABLE_PLACEHOLDER, configuration.getTable());
    }

    @Override
    public void updateFilenamePlaceholder(ResourceName resourceName) {
        if (resourceName.isValid()) {
            this.placeholders.put(FILENAME_PLACEHOLDER, resourceName.getFilename());
        } else {
            this.placeholders.remove(FILENAME_PLACEHOLDER);
        }
    }

    private Schema getCurrentSchema(Database database) {
        try {
            return database.getMainSession().getCurrentSchema();
        }
        catch (MigrateDbException e) {
            LOG.debug("Could not get schema for migratedb:defaultSchema placeholder.");
            return null;
        }
    }

    private String getCurrentUser(Database database) {
        try {
            return database.getCurrentUser();
        }
        catch (MigrateDbException e) {
            LOG.debug("Could not get user for migratedb:user placeholder.");
            return null;
        }
    }
}

