/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.logging;

import java.util.Collection;
import java.util.List;
import migratedb.v1.core.api.logging.LogSystem;

public class MultiLogSystem
implements LogSystem {
    private final List<LogSystem> delegates;

    public MultiLogSystem(Collection<LogSystem> delegates) {
        this.delegates = List.copyOf(delegates);
    }

    public String toString() {
        return this.delegates.toString();
    }

    @Override
    public boolean isDebugEnabled(String logName) {
        for (LogSystem log : this.delegates) {
            if (log.isDebugEnabled(logName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void debug(String logName, String message) {
        for (LogSystem log : this.delegates) {
            log.debug(logName, message);
        }
    }

    @Override
    public void info(String logName, String message) {
        for (LogSystem log : this.delegates) {
            log.info(logName, message);
        }
    }

    @Override
    public void warn(String logName, String message) {
        for (LogSystem log : this.delegates) {
            log.warn(logName, message);
        }
    }

    @Override
    public void error(String logName, String message) {
        for (LogSystem log : this.delegates) {
            log.error(logName, message);
        }
    }

    @Override
    public void error(String logName, String message, Exception e) {
        for (LogSystem log : this.delegates) {
            log.error(logName, message, e);
        }
    }
}

