/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.jdbc;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.ExecutionTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class PlainExecutionTemplate
implements ExecutionTemplate {
    private static final Log LOG = Log.getLog(PlainExecutionTemplate.class);
    private final boolean skipErrorLog;

    public PlainExecutionTemplate() {
        this.skipErrorLog = false;
    }

    public PlainExecutionTemplate(boolean skipErrorLog) {
        this.skipErrorLog = skipErrorLog;
    }

    @Override
    public <T> T execute(Callable<T> callback) {
        try {
            LOG.debug("Performing operation in non-transactional context.");
            return callback.call();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (!this.skipErrorLog) {
                LOG.error("Failed to execute operation in non-transactional context. Please restore backups and roll back database and code!");
            }
            if (e instanceof SQLException) {
                throw new MigrateDbSqlException("Failed to execute operation.", (SQLException)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MigrateDbException(e);
        }
    }
}

