/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.jdbc;

import java.sql.Connection;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.ExecutionTemplate;
import migratedb.v1.core.internal.jdbc.PlainExecutionTemplate;
import migratedb.v1.core.internal.jdbc.TableLockingExecutionTemplate;

public class ExecutionTemplateFactory {
    public static ExecutionTemplate createExecutionTemplate(Connection connection, DatabaseTypeRegister databaseTypeRegister) {
        return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true, databaseTypeRegister.getDatabaseTypeForConnection(connection));
    }

    public static ExecutionTemplate createExecutionTemplate(Connection connection, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true, database.getDatabaseType());
        }
        return new PlainExecutionTemplate();
    }

    public static ExecutionTemplate createTableExclusiveExecutionTemplate(Connection connection, Table table, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return new TableLockingExecutionTemplate(table, ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, database.supportsDdlTransactions(), database.getDatabaseType()));
        }
        return new TableLockingExecutionTemplate(table, new PlainExecutionTemplate());
    }

    private static ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException, DatabaseType databaseType) {
        return databaseType.createTransactionalExecutionTemplate(connection, rollbackOnException);
    }
}

