/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.info.NavigableMigrations;

class NavigableMigrationsBuilder {
    private final List<ResolvedMigration> allResolvedMigrations;
    private final List<AppliedMigration> allAppliedMigrationsInExecutionOrder;
    private final Set<Version> deletedVersions;
    private final Set<String> deletedRepeatableDescriptions;
    private final Set<Version> outOfOrderVersions;
    private final Holder<List<AppliedMigration>> appliedRepeatableMigrations = new Holder();
    private final Holder<List<AppliedMigration>> appliedIncrementalOrBaselineMigrations = new Holder();
    private final Holder<Map<String, ResolvedMigration>> resolvedRepeatableMigrations = new Holder();
    private final Holder<Map<Version, ResolvedMigration>> resolvedIncrementalMigrations = new Holder();
    private final Holder<Map<Version, ResolvedMigration>> resolvedBaselineMigrations = new Holder();

    NavigableMigrationsBuilder(Collection<ResolvedMigration> allResolvedMigrations, Collection<AppliedMigration> allAppliedMigrations) {
        this.allResolvedMigrations = List.copyOf(allResolvedMigrations);
        this.allAppliedMigrationsInExecutionOrder = allAppliedMigrations.stream().sorted(Comparator.comparing(AppliedMigration::getInstalledRank)).collect(Collectors.toList());
        this.deletedVersions = this.allAppliedMigrationsInExecutionOrder.stream().filter(it -> MigrationType.DELETED.equals((Object)it.getType()) && it.getVersion() != null).map(AppliedMigration::getVersion).collect(Collectors.toSet());
        this.deletedRepeatableDescriptions = this.allAppliedMigrationsInExecutionOrder.stream().filter(it -> MigrationType.DELETED.equals((Object)it.getType()) && it.getVersion() == null).map(AppliedMigration::getDescription).collect(Collectors.toSet());
        this.outOfOrderVersions = new HashSet<Version>();
        Version prev = null;
        for (AppliedMigration applied : this.allAppliedMigrationsInExecutionOrder) {
            Version next = applied.getVersion();
            if (next == null) continue;
            if (prev != null && prev.compareTo(next) >= 0) {
                this.outOfOrderVersions.add(next);
            }
            prev = next;
        }
    }

    NavigableMigrations build() {
        Map<String, NavigableMigrations.RepeatableMigrationEntry> repeatableInfo = this.infoAboutRepeatableMigrations();
        Map<Version, NavigableMigrations.VersionedMigrationEntry> versionedInfo = this.infoAboutVersionedMigrations();
        List schemaCreationMarker = this.allAppliedMigrationsInExecutionOrder.stream().filter(it -> MigrationType.SCHEMA.equals((Object)it.getType())).collect(Collectors.toList());
        if (schemaCreationMarker.size() > 1) {
            throw new MigrateDbException("Schema history corrupted: More than one schema creation marker found");
        }
        return new NavigableMigrations(repeatableInfo, new TreeMap<Version, NavigableMigrations.VersionedMigrationEntry>(versionedInfo));
    }

    private Map<Version, NavigableMigrations.VersionedMigrationEntry> infoAboutVersionedMigrations() {
        Stream<Version> appliedVersions = this.appliedVersionedMigrations().stream().map(AppliedMigration::getVersion);
        Stream<Version> resolvedIncrementalVersions = this.resolvedIncrementalMigrations().values().stream().map(ResolvedMigration::getVersion);
        Stream<Version> resolvedBaselineVersions = this.resolvedBaselineMigrations().values().stream().map(ResolvedMigration::getVersion);
        return Stream.of(appliedVersions, resolvedIncrementalVersions, resolvedBaselineVersions).flatMap(Function.identity()).distinct().map(this::gatherVersionedMigrationInfo).collect(Collectors.toMap(it -> it.version, Function.identity()));
    }

    private Map<String, NavigableMigrations.RepeatableMigrationEntry> infoAboutRepeatableMigrations() {
        Stream<String> appliedDescriptions = this.appliedRepeatableMigrations().stream().map(AppliedMigration::getDescription);
        Stream<String> resolvedDescriptions = this.resolvedRepeatableMigrations().values().stream().map(ResolvedMigration::getDescription);
        return Stream.of(appliedDescriptions, resolvedDescriptions).flatMap(Function.identity()).distinct().map(this::gatherRepeatableMigrationInfo).collect(Collectors.toMap(it -> it.description, Function.identity()));
    }

    private NavigableMigrations.VersionedMigrationEntry gatherVersionedMigrationInfo(Version version) {
        ResolvedMigration resolvedBaseline = this.resolvedBaselineMigrations().get(version);
        ResolvedMigration resolvedIncremental = this.resolvedIncrementalMigrations().get(version);
        List applied = this.appliedVersionedMigrations().stream().filter(it -> version.equals(it.getVersion())).collect(Collectors.toList());
        if (applied.size() > 1) {
            throw new MigrateDbException("Schema history corrupted: More than one applied migration exists for version " + version);
        }
        boolean deleted = this.deletedVersions.contains(version);
        boolean outOfOrder = this.outOfOrderVersions.contains(version);
        return new NavigableMigrations.VersionedMigrationEntry(version, resolvedIncremental, resolvedBaseline, applied.isEmpty() ? null : (AppliedMigration)applied.get(0), deleted, outOfOrder);
    }

    private NavigableMigrations.RepeatableMigrationEntry gatherRepeatableMigrationInfo(String description) {
        ResolvedMigration resolved = this.resolvedRepeatableMigrations().get(description);
        List allApplied = this.appliedRepeatableMigrations().stream().filter(it -> description.equals(it.getDescription())).sorted(Comparator.comparing(AppliedMigration::getInstalledRank)).collect(Collectors.toList());
        boolean deleted = this.deletedRepeatableDescriptions.contains(description);
        List<AppliedMigration> supersededRuns = allApplied.isEmpty() ? List.of() : allApplied.subList(0, allApplied.size() - 1);
        AppliedMigration latestApplied = allApplied.isEmpty() ? null : (AppliedMigration)allApplied.get(allApplied.size() - 1);
        return new NavigableMigrations.RepeatableMigrationEntry(description, resolved, latestApplied, supersededRuns, deleted);
    }

    private List<AppliedMigration> appliedRepeatableMigrations() {
        return NavigableMigrationsBuilder.computeOnce(this.appliedRepeatableMigrations, () -> this.allAppliedMigrationsInExecutionOrder.stream().filter(AppliedMigration::isExecutionOfRepeatableMigration).collect(Collectors.toList()));
    }

    private List<AppliedMigration> appliedVersionedMigrations() {
        return NavigableMigrationsBuilder.computeOnce(this.appliedIncrementalOrBaselineMigrations, () -> this.allAppliedMigrationsInExecutionOrder.stream().filter(it -> !MigrationType.SCHEMA.equals((Object)it.getType()) && !it.isExecutionOfRepeatableMigration()).collect(Collectors.toList()));
    }

    private Map<String, ResolvedMigration> resolvedRepeatableMigrations() {
        return NavigableMigrationsBuilder.computeOnce(this.resolvedRepeatableMigrations, () -> this.allResolvedMigrations.stream().filter(ResolvedMigration::isRepeatable).collect(Collectors.toMap(ResolvedMigration::getDescription, Function.identity())));
    }

    private Map<Version, ResolvedMigration> resolvedIncrementalMigrations() {
        return NavigableMigrationsBuilder.computeOnce(this.resolvedIncrementalMigrations, () -> this.allResolvedMigrations.stream().filter(it -> !it.isRepeatable() && !it.getType().isBaselineMigration()).collect(Collectors.toMap(ResolvedMigration::getVersion, Function.identity())));
    }

    private Map<Version, ResolvedMigration> resolvedBaselineMigrations() {
        return NavigableMigrationsBuilder.computeOnce(this.resolvedBaselineMigrations, () -> this.allResolvedMigrations.stream().filter(it -> it.getType().isBaselineMigration()).collect(Collectors.toMap(ResolvedMigration::getVersion, Function.identity())));
    }

    private static <T> T computeOnce(Holder<T> holder, Supplier<T> computation) {
        Object result = holder.value;
        if (result == null) {
            holder.value = result = computation.get();
        }
        return result;
    }

    private static final class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

