/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.function.Predicate;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NavigableMigrations {
    final @Nullable Version baseline;
    final Map<String, RepeatableMigrationEntry> repeatableMigrations;
    final NavigableMap<Version, VersionedMigrationEntry> versionedMigrations;

    NavigableMigrations(Map<String, RepeatableMigrationEntry> repeatableMigrations, NavigableMap<Version, VersionedMigrationEntry> versionedMigrations) {
        this.repeatableMigrations = repeatableMigrations;
        this.versionedMigrations = versionedMigrations;
        this.baseline = versionedMigrations.values().stream().filter(it -> it.appliedMigration != null && it.appliedMigration.isSuccess() && it.appliedMigration.getType().isBaselineMigration()).max(Comparator.comparing(it -> it.version)).map(it -> it.version).orElse(null);
    }

    Optional<ResolvedMigration> latestResolvedVersioned() {
        return this.versionedMigrations.descendingMap().values().stream().filter(it -> it.resolvedBaselineMigration != null || it.resolvedIncrementalMigration != null && !it.deleted).findFirst().map(it -> it.resolvedIncrementalMigration == null ? it.resolvedBaselineMigration : it.resolvedIncrementalMigration);
    }

    Optional<AppliedMigration> latestAppliedVersioned() {
        return this.latestAppliedVersioned(it -> true);
    }

    Optional<AppliedMigration> latestAppliedVersioned(Predicate<AppliedMigration> filter) {
        return this.versionedMigrations.descendingMap().values().stream().filter(it -> it.appliedMigration != null && filter.test(it.appliedMigration)).findFirst().map(it -> it.appliedMigration);
    }

    static final class VersionedMigrationEntry {
        final Version version;
        final @Nullable ResolvedMigration resolvedIncrementalMigration;
        final @Nullable ResolvedMigration resolvedBaselineMigration;
        final @Nullable AppliedMigration appliedMigration;
        final boolean deleted;
        final boolean outOfOrder;

        VersionedMigrationEntry(Version version, @Nullable ResolvedMigration resolvedIncrementalMigration, @Nullable ResolvedMigration resolvedBaselineMigration, @Nullable AppliedMigration appliedMigration, boolean deleted, boolean outOfOrder) {
            this.version = version;
            this.resolvedIncrementalMigration = resolvedIncrementalMigration;
            this.resolvedBaselineMigration = resolvedBaselineMigration;
            this.appliedMigration = appliedMigration;
            this.deleted = deleted;
            this.outOfOrder = outOfOrder;
        }

        boolean shouldNotExecute() {
            boolean shouldExecuteBaseline = this.resolvedBaselineMigration == null || this.resolvedBaselineMigration.getExecutor().shouldExecute();
            boolean shouldExecuteIncremental = this.resolvedIncrementalMigration == null || this.resolvedIncrementalMigration.getExecutor().shouldExecute();
            return !shouldExecuteBaseline && !shouldExecuteIncremental;
        }
    }

    static final class RepeatableMigrationEntry {
        final String description;
        final @Nullable ResolvedMigration resolvedMigration;
        final AppliedMigration latestAppliedMigration;
        final List<AppliedMigration> supersededRuns;
        final boolean deleted;

        RepeatableMigrationEntry(String description, @Nullable ResolvedMigration resolvedMigration, AppliedMigration latestAppliedMigration, List<AppliedMigration> supersededRuns, boolean deleted) {
            this.description = description;
            this.resolvedMigration = resolvedMigration;
            this.latestAppliedMigration = latestAppliedMigration;
            this.supersededRuns = supersededRuns;
            this.deleted = deleted;
        }

        boolean shouldNotExecute() {
            return this.resolvedMigration != null && !this.resolvedMigration.getExecutor().shouldExecute();
        }
    }
}

