/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import migratedb.v1.core.api.ErrorDetails;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.MigrationInfoService;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.MigrationState;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.output.CommandResultFactory;
import migratedb.v1.core.api.output.InfoResult;
import migratedb.v1.core.api.output.OperationResult;
import migratedb.v1.core.api.output.ValidateOutput;
import migratedb.v1.core.api.resolver.Context;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.info.RefreshHelper;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public class MigrationInfoServiceImpl
extends OperationResult
implements MigrationInfoService {
    private final MigrationResolver migrationResolver;
    private final Configuration configuration;
    private final Database database;
    private final Context context;
    private final SchemaHistory schemaHistory;
    private final TargetVersion target;
    private final List<MigrationPattern> cherryPick;
    private final ValidationContext validationContext;
    private List<MigrationInfo> migrationInfo;
    private boolean allSchemasEmpty;

    public MigrationInfoServiceImpl(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Configuration configuration, TargetVersion target, List<MigrationPattern> cherryPick, ValidationContext validationContext) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.configuration = configuration;
        this.context = () -> configuration;
        this.database = database;
        this.target = target;
        this.cherryPick = cherryPick;
        this.validationContext = validationContext;
    }

    public void refresh() {
        List<MigrationInfo> newMigrationInfo = new RefreshHelper(this.migrationResolver.resolveMigrations(this.context), this.schemaHistory.allAppliedMigrations(), this.cherryPick, this.target, this.validationContext).getMigrationInfo();
        this.failOnMissingTarget(newMigrationInfo);
        this.migrationInfo = newMigrationInfo;
    }

    private void failOnMissingTarget(List<MigrationInfo> migrations) {
        if (this.configuration.isFailOnMissingTarget() && this.target != null) {
            this.target.withVersion(version -> {
                boolean targetFound = migrations.stream().anyMatch(it -> version.equals(it.getVersion()));
                if (!targetFound) {
                    throw new MigrateDbException("No migration with a target version " + this.target + " could be found. Ensure target is specified correctly and the migration exists.");
                }
            }).orElseDoNothing();
        }
    }

    @Override
    public MigrationInfo[] all() {
        return (MigrationInfo[])this.migrationInfo.toArray(MigrationInfo[]::new);
    }

    @Override
    public MigrationInfo current() {
        return this.migrationInfo.stream().filter(it -> it.getState().is(MigrationState.Category.APPLIED) && it.getState() != MigrationState.DELETED && it.getVersion() != null).max(Comparator.comparing(MigrationInfo::getVersion)).or(this::latestAppliedRepeatableMigration).orElse(null);
    }

    private Optional<? extends MigrationInfo> latestAppliedRepeatableMigration() {
        for (int i = this.migrationInfo.size() - 1; i >= 0; --i) {
            MigrationInfo migrationInfo = this.migrationInfo.get(i);
            if (!migrationInfo.getState().is(MigrationState.Category.APPLIED) || MigrationState.DELETED.equals((Object)migrationInfo.getState())) continue;
            return Optional.of(migrationInfo);
        }
        return Optional.empty();
    }

    @Override
    public MigrationInfo next() {
        MigrationInfo[] pending = this.pending();
        if (pending.length > 0) {
            return pending[0];
        }
        MigrationInfo[] outdated = this.outdated();
        if (outdated.length > 0) {
            return outdated[0];
        }
        return null;
    }

    @Override
    public MigrationInfo[] pending() {
        return this.filterByState(it -> it == MigrationState.PENDING);
    }

    @Override
    public MigrationInfo[] applied() {
        return this.filterByState(it -> it.is(MigrationState.Category.APPLIED));
    }

    @Override
    public MigrationInfo[] resolved() {
        return this.filterByState(it -> it.is(MigrationState.Category.RESOLVED));
    }

    @Override
    public MigrationInfo[] failed() {
        return this.filterByState(it -> it.is(MigrationState.Category.FAILED));
    }

    @Override
    public MigrationInfo[] future() {
        return this.filterByState(it -> it.is(MigrationState.Category.FUTURE));
    }

    @Override
    public MigrationInfo[] outOfOrder() {
        return this.filterByState(MigrationState.OUT_OF_ORDER::equals);
    }

    @Override
    public MigrationInfo[] outdated() {
        return this.filterByState(MigrationState.OUTDATED::equals);
    }

    private MigrationInfo[] filterByState(Predicate<MigrationState> predicate) {
        return (MigrationInfo[])this.migrationInfo.stream().filter(it -> predicate.test(it.getState())).toArray(MigrationInfo[]::new);
    }

    public List<ValidateOutput> validate() {
        ArrayList<ValidateOutput> invalidMigrations = new ArrayList<ValidateOutput>();
        for (MigrationInfo migrationInfo : this.migrationInfo) {
            ErrorDetails validateError = migrationInfo.validate();
            if (validateError == null) continue;
            invalidMigrations.add(CommandResultFactory.createValidateOutput(migrationInfo, validateError));
        }
        return invalidMigrations;
    }

    public void setAllSchemasEmpty(Schema[] schemas) {
        this.allSchemasEmpty = Arrays.stream(schemas).filter(Schema::exists).allMatch(Schema::isEmpty);
    }

    @Override
    public InfoResult getInfoResult() {
        return this.getInfoResult(this.all());
    }

    public InfoResult getInfoResult(MigrationInfo[] infos) {
        return CommandResultFactory.createInfoResult(this.context.getConfiguration(), this.database, infos, this.current(), this.allSchemasEmpty);
    }
}

