/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.time.Instant;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.ErrorDetails;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.MigrationState;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.info.ValidationMatch;
import migratedb.v1.core.internal.info.VersionContext;
import migratedb.v1.core.internal.util.AbbreviationUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MigrationInfoImpl
implements MigrationInfo {
    private final @Nullable ResolvedMigration resolvedMigration;
    private final @Nullable AppliedMigration appliedMigration;
    private final ValidationContext validationContext;
    private final VersionContext versionContext;
    private final MigrationState state;
    private final boolean shouldNotExecuteMigration;

    MigrationInfoImpl(@Nullable ResolvedMigration resolvedMigration, @Nullable AppliedMigration appliedMigration, ValidationContext validationContext, VersionContext versionContext, MigrationState state, boolean shouldNotExecuteMigration) {
        if (resolvedMigration == null && appliedMigration == null) {
            throw new IllegalArgumentException("One of (resolved migration, applied migration) must not be null");
        }
        this.resolvedMigration = resolvedMigration;
        this.appliedMigration = appliedMigration;
        this.validationContext = validationContext;
        this.versionContext = versionContext;
        this.state = state;
        this.shouldNotExecuteMigration = shouldNotExecuteMigration;
    }

    @Override
    public @Nullable ResolvedMigration getResolvedMigration() {
        return this.resolvedMigration;
    }

    @Override
    public @Nullable AppliedMigration getAppliedMigration() {
        return this.appliedMigration;
    }

    @Override
    public MigrationType getType() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getType();
        }
        assert (this.resolvedMigration != null);
        return this.resolvedMigration.getType();
    }

    @Override
    public Checksum getChecksum() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getChecksum();
        }
        assert (this.resolvedMigration != null);
        return this.resolvedMigration.getChecksum();
    }

    @Override
    public Version getVersion() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getVersion();
        }
        assert (this.resolvedMigration != null);
        return this.resolvedMigration.getVersion();
    }

    @Override
    public String getDescription() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getDescription();
        }
        assert (this.resolvedMigration != null);
        return this.resolvedMigration.getDescription();
    }

    @Override
    public String getScript() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getScript();
        }
        assert (this.resolvedMigration != null);
        return this.resolvedMigration.getScript();
    }

    @Override
    public MigrationState getState() {
        return this.state;
    }

    @Override
    public Instant getInstalledOn() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledOn();
        }
        return null;
    }

    @Override
    public String getInstalledBy() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledBy();
        }
        return null;
    }

    @Override
    public Integer getInstalledRank() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledRank();
        }
        return null;
    }

    @Override
    public Integer getExecutionTime() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getExecutionTime();
        }
        return null;
    }

    @Override
    public String getPhysicalLocation() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getLocationDescription();
        }
        return "";
    }

    @Override
    public @Nullable ErrorDetails validate() {
        MigrationState state = this.getState();
        if (MigrationState.ABOVE_TARGET.equals((Object)state)) {
            return null;
        }
        if (MigrationState.DELETED.equals((Object)state)) {
            return null;
        }
        if (state.is(MigrationState.Category.FAILED) && (!this.validationContext.allows(ValidationMatch.FUTURE) || MigrationState.FUTURE_FAILED != state)) {
            if (this.getVersion() == null) {
                String errorMessage = "Detected failed repeatable migration: " + this.getDescription() + ". Please remove any half-completed changes then run repair to fix the schema history.";
                return new ErrorDetails(ErrorCode.FAILED_REPEATABLE_MIGRATION, errorMessage);
            }
            String errorMessage = "Detected failed migration to version " + this.getVersion() + " (" + this.getDescription() + "). Please remove any half-completed changes then run repair to fix the schema history.";
            return new ErrorDetails(ErrorCode.FAILED_VERSIONED_MIGRATION, errorMessage);
        }
        if (this.resolvedMigration == null) {
            assert (this.appliedMigration != null);
            if (!(this.appliedMigration.getType().isExclusiveToAppliedMigrations() || MigrationState.SUPERSEDED == state || this.validationContext.allows(ValidationMatch.MISSING) && (MigrationState.MISSING_SUCCESS == state || MigrationState.MISSING_FAILED == state) || this.validationContext.allows(ValidationMatch.FUTURE) && (MigrationState.FUTURE_SUCCESS == state || MigrationState.FUTURE_FAILED == state))) {
                if (this.appliedMigration.getVersion() != null) {
                    String errorMessage = "Detected applied migration not resolved locally: " + this.getVersion() + ". If you removed this migration intentionally, run repair to mark the migration as deleted.";
                    return new ErrorDetails(ErrorCode.APPLIED_VERSIONED_MIGRATION_NOT_RESOLVED, errorMessage);
                }
                String errorMessage = "Detected applied migration not resolved locally: " + this.getDescription() + ". If you removed this migration intentionally, run repair to mark the migration as deleted.";
                return new ErrorDetails(ErrorCode.APPLIED_REPEATABLE_MIGRATION_NOT_RESOLVED, errorMessage);
            }
        }
        if (!this.validationContext.allows(ValidationMatch.IGNORED) && MigrationState.IGNORED == state) {
            if (this.shouldNotExecuteMigration) {
                return null;
            }
            if (this.getVersion() != null) {
                String errorMessage = "Detected resolved migration not applied to database: " + this.getVersion() + ". To ignore this migration, set -ignoreIgnoredMigrations=true. To allow executing this migration, set -outOfOrder=true.";
                return new ErrorDetails(ErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, errorMessage);
            }
            String errorMessage = "Detected resolved repeatable migration not applied to database: " + this.getDescription() + ". To ignore this migration, set -ignoreIgnoredMigrations=true.";
            return new ErrorDetails(ErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, errorMessage);
        }
        if (!this.validationContext.allows(ValidationMatch.PENDING) && MigrationState.PENDING == state) {
            if (this.getVersion() != null) {
                String errorMessage = "Detected resolved migration not applied to database: " + this.getVersion() + ". To fix this error, either run migrate, or set -ignorePendingMigrations=true.";
                return new ErrorDetails(ErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, errorMessage);
            }
            String errorMessage = "Detected resolved repeatable migration not applied to database: " + this.getDescription() + ". To fix this error, either run migrate, or set -ignorePendingMigrations=true.";
            return new ErrorDetails(ErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, errorMessage);
        }
        if (!this.validationContext.allows(ValidationMatch.PENDING) && MigrationState.OUTDATED == state) {
            String errorMessage = "Detected outdated resolved repeatable migration that should be re-applied to database: " + this.getDescription() + ". Run migrate to execute this migration.";
            return new ErrorDetails(ErrorCode.OUTDATED_REPEATABLE_MIGRATION, errorMessage);
        }
        if (this.resolvedMigration != null && this.appliedMigration != null && this.getType() != MigrationType.DELETED) {
            Object migrationIdentifier;
            Object object = migrationIdentifier = this.appliedMigration.getVersion() == null ? this.appliedMigration.getScript() : "version " + this.appliedMigration.getVersion();
            if (this.getVersion() == null || this.versionContext.baselineVersion == null || this.getVersion().compareTo(this.versionContext.baselineVersion) > 0) {
                if (this.resolvedMigration.getType() != this.appliedMigration.getType()) {
                    String mismatchMessage = this.createMismatchMessage("type", (String)migrationIdentifier, (Object)this.appliedMigration.getType(), (Object)this.resolvedMigration.getType());
                    return new ErrorDetails(ErrorCode.TYPE_MISMATCH, mismatchMessage);
                }
                if ((this.resolvedMigration.getVersion() != null || this.validationContext.allows(ValidationMatch.PENDING) && MigrationState.OUTDATED != state && MigrationState.SUPERSEDED != state) && !this.resolvedMigration.checksumMatches(this.appliedMigration.getChecksum())) {
                    String mismatchMessage = this.createMismatchMessage("checksum", (String)migrationIdentifier, this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum());
                    return new ErrorDetails(ErrorCode.CHECKSUM_MISMATCH, mismatchMessage);
                }
                if (this.descriptionMismatch(this.resolvedMigration, this.appliedMigration)) {
                    String mismatchMessage = this.createMismatchMessage("description", (String)migrationIdentifier, this.appliedMigration.getDescription(), this.resolvedMigration.getDescription());
                    return new ErrorDetails(ErrorCode.DESCRIPTION_MISMATCH, mismatchMessage);
                }
            }
        }
        return null;
    }

    private boolean descriptionMismatch(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration) {
        if ("<< no description >>".equals(appliedMigration.getDescription())) {
            return !"".equals(resolvedMigration.getDescription()) && !"<< no description >>".equals(resolvedMigration.getDescription());
        }
        return !AbbreviationUtils.abbreviateDescription(resolvedMigration.getDescription()).equals(appliedMigration.getDescription());
    }

    private String createMismatchMessage(String mismatch, String migrationIdentifier, Object applied, Object resolved) {
        return String.format("Migration " + mismatch + " mismatch for migration %s\n-> Applied to database : %s\n-> Resolved locally    : %s. Either revert the changes to the migration, or run repair to update the schema history.", migrationIdentifier, applied, resolved);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{resolved=" + this.resolvedMigration + ", applied=" + this.appliedMigration + ", state= " + this.state + "}";
    }
}

