/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.Comparator;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.MigrationState;

public final class MigrationExecutionOrdering
implements Comparator<MigrationInfo> {
    @Override
    public int compare(MigrationInfo o1, MigrationInfo o2) {
        if (o1.getInstalledRank() != null && o2.getInstalledRank() != null) {
            return o1.getInstalledRank().compareTo(o2.getInstalledRank());
        }
        MigrationState state = o1.getState();
        MigrationState oState = o2.getState();
        if (state == MigrationState.BELOW_BASELINE && oState.is(MigrationState.Category.APPLIED)) {
            return -1;
        }
        if (state.is(MigrationState.Category.APPLIED) && oState == MigrationState.BELOW_BASELINE) {
            return 1;
        }
        if (o1.getInstalledRank() != null) {
            return -1;
        }
        if (o2.getInstalledRank() != null) {
            return 1;
        }
        return this.compareVersion(o1, o2);
    }

    private int compareVersion(MigrationInfo o1, MigrationInfo o2) {
        if (o1.getVersion() != null && o2.getVersion() != null) {
            return o1.getVersion().compareTo(o2.getVersion());
        }
        if (o1.getVersion() != null) {
            return -1;
        }
        if (o2.getVersion() != null) {
            return 1;
        }
        return o1.getDescription().compareTo(o2.getDescription());
    }
}

