/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.yugabytedb;

import java.sql.Connection;
import java.util.regex.Pattern;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLDatabaseType;
import migratedb.v1.core.internal.database.yugabytedb.YugabyteDBDatabase;
import migratedb.v1.core.internal.database.yugabytedb.YugabyteDBParser;
import migratedb.v1.core.internal.parser.BaseParser;

public class YugabyteDBDatabaseType
extends PostgreSQLDatabaseType {
    @Override
    public String getName() {
        return "YugabyteDB";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("PostgreSQL") && Pattern.matches("PostgreSQL\\s\\d{1,2}(\\.\\d{1,2})?-YB-\\d{1,2}(\\.\\d{1,2})?.*", YugabyteDBDatabaseType.getSelectVersionOutput(connection));
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        return new YugabyteDBDatabase(configuration, jdbcConnectionFactory);
    }

    @Override
    public BaseParser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new YugabyteDBParser(configuration, parsingContext);
    }
}

