/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.sqlserver.SQLServerDatabase;
import migratedb.v1.core.internal.database.sqlserver.SQLServerTable;

public class SQLServerSchema
extends BaseSchema {
    protected final String databaseName;

    public SQLServerSchema(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, String name) {
        super(jdbcTemplate, database, name);
        this.databaseName = databaseName;
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        boolean empty = this.queryDBObjects(ObjectType.SCALAR_FUNCTION, ObjectType.AGGREGATE, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.STORED_PROCEDURE, ObjectType.CLR_STORED_PROCEDURE, ObjectType.USER_TABLE, ObjectType.SYNONYM, ObjectType.SEQUENCE_OBJECT, ObjectType.FOREIGN_KEY, ObjectType.VIEW).isEmpty();
        if (empty) {
            int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM ( SELECT t.name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name = ? Union SELECT name FROM sys.assemblies WHERE is_user_defined=1) R", this.name);
            empty = objectCount == 0;
        }
        return empty;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<DBObject> queryDBObjects(ObjectType ... types) throws SQLException {
        return this.queryDBObjectsWithParent(null, types);
    }

    private List<DBObject> queryDBObjectsWithParent(DBObject parent, ObjectType ... types) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT obj.object_id, obj.name FROM sys.objects AS obj LEFT JOIN sys.extended_properties AS eps ON obj.object_id = eps.major_id AND eps.class = 1 AND eps.minor_id = 0 AND eps.name='microsoft_database_tools_support' WHERE SCHEMA_NAME(obj.schema_id) = '" + this.name + "' AND eps.major_id IS NULL AND obj.is_ms_shipped = 0 AND obj.type IN (");
        boolean first = true;
        for (ObjectType type : types) {
            if (!first) {
                query.append(", ");
            }
            query.append("'").append(type.code).append("'");
            first = false;
        }
        query.append(")");
        if (parent != null) {
            query.append(" AND obj.parent_object_id = ").append(parent.objectId);
        }
        query.append(" order by create_date desc, object_id desc");
        return this.jdbcTemplate.query(query.toString(), rs -> new DBObject(rs.getLong("object_id"), rs.getString("name")), new Object[0]);
    }

    protected List<? extends SQLServerTable> doAllTables() throws SQLException {
        return this.queryDBObjects(ObjectType.USER_TABLE).stream().map(table -> new SQLServerTable(this.jdbcTemplate, this.getDatabase(), this.databaseName, this, table.name)).collect(Collectors.toList());
    }

    @Override
    protected SQLServerDatabase getDatabase() {
        return (SQLServerDatabase)super.getDatabase();
    }

    @Override
    public SQLServerTable getTable(String tableName) {
        return new SQLServerTable(this.jdbcTemplate, this.getDatabase(), this.databaseName, this, tableName);
    }

    protected static final class ObjectType
    extends Enum<ObjectType> {
        public static final /* enum */ ObjectType AGGREGATE = new ObjectType("AF");
        public static final /* enum */ ObjectType CHECK_CONSTRAINT = new ObjectType("C");
        public static final /* enum */ ObjectType DEFAULT_CONSTRAINT = new ObjectType("D");
        public static final /* enum */ ObjectType PRIMARY_KEY = new ObjectType("PK");
        public static final /* enum */ ObjectType FOREIGN_KEY = new ObjectType("F");
        public static final /* enum */ ObjectType INLINED_TABLE_FUNCTION = new ObjectType("IF");
        public static final /* enum */ ObjectType SCALAR_FUNCTION = new ObjectType("FN");
        public static final /* enum */ ObjectType CLR_SCALAR_FUNCTION = new ObjectType("FS");
        public static final /* enum */ ObjectType CLR_TABLE_VALUED_FUNCTION = new ObjectType("FT");
        public static final /* enum */ ObjectType STORED_PROCEDURE = new ObjectType("P");
        public static final /* enum */ ObjectType CLR_STORED_PROCEDURE = new ObjectType("PC");
        public static final /* enum */ ObjectType RULE = new ObjectType("R");
        public static final /* enum */ ObjectType SYNONYM = new ObjectType("SN");
        public static final /* enum */ ObjectType TABLE_VALUED_FUNCTION = new ObjectType("TF");
        public static final /* enum */ ObjectType ASSEMBLY_DML_TRIGGER = new ObjectType("TA");
        public static final /* enum */ ObjectType SQL_DML_TRIGGER = new ObjectType("TR");
        public static final /* enum */ ObjectType UNIQUE_CONSTRAINT = new ObjectType("UQ");
        public static final /* enum */ ObjectType USER_TABLE = new ObjectType("U");
        public static final /* enum */ ObjectType VIEW = new ObjectType("V");
        public static final /* enum */ ObjectType SEQUENCE_OBJECT = new ObjectType("SO");
        public final String code;
        private static final /* synthetic */ ObjectType[] $VALUES;

        public static ObjectType[] values() {
            return (ObjectType[])$VALUES.clone();
        }

        public static ObjectType valueOf(String name) {
            return Enum.valueOf(ObjectType.class, name);
        }

        private ObjectType(String code) {
            assert (code != null);
            this.code = code;
        }

        private static /* synthetic */ ObjectType[] $values() {
            return new ObjectType[]{AGGREGATE, CHECK_CONSTRAINT, DEFAULT_CONSTRAINT, PRIMARY_KEY, FOREIGN_KEY, INLINED_TABLE_FUNCTION, SCALAR_FUNCTION, CLR_SCALAR_FUNCTION, CLR_TABLE_VALUED_FUNCTION, STORED_PROCEDURE, CLR_STORED_PROCEDURE, RULE, SYNONYM, TABLE_VALUED_FUNCTION, ASSEMBLY_DML_TRIGGER, SQL_DML_TRIGGER, UNIQUE_CONSTRAINT, USER_TABLE, VIEW, SEQUENCE_OBJECT};
        }

        static {
            $VALUES = ObjectType.$values();
        }
    }

    public static class DBObject {
        public final String name;
        public final long objectId;

        public DBObject(long objectId, String name) {
            assert (name != null);
            this.objectId = objectId;
            this.name = name;
        }
    }
}

