/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.sqlscript.Delimiter;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.sqlserver.SQLServerEngineEdition;
import migratedb.v1.core.internal.database.sqlserver.SQLServerSession;
import migratedb.v1.core.internal.util.StringUtils;

public class SQLServerDatabase
extends BaseDatabase {
    public SQLServerDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected SQLServerSession doGetSession(Connection connection) {
        return new SQLServerSession(this, connection);
    }

    @Override
    public final void ensureSupported() {
        if (this.isAzure()) {
            this.ensureDatabaseIsRecentEnough("11.0");
            this.recommendMigrateDbUpgradeIfNecessary("16.0");
        } else {
            this.ensureDatabaseIsRecentEnough("10.0");
            this.recommendMigrateDbUpgradeIfNecessary("16.0");
        }
    }

    @Override
    protected String computeVersionDisplayName(Version version) {
        if (this.isAzure()) {
            return "Azure v" + this.getVersion().getMajorAsString();
        }
        if (this.getVersion().isAtLeast("8")) {
            if ("8".equals(this.getVersion().getMajorAsString())) {
                return "2000";
            }
            if ("9".equals(this.getVersion().getMajorAsString())) {
                return "2005";
            }
            if ("10".equals(this.getVersion().getMajorAsString())) {
                if ("0".equals(this.getVersion().getMinorAsString())) {
                    return "2008";
                }
                return "2008 R2";
            }
            if ("11".equals(this.getVersion().getMajorAsString())) {
                return "2012";
            }
            if ("12".equals(this.getVersion().getMajorAsString())) {
                return "2014";
            }
            if ("13".equals(this.getVersion().getMajorAsString())) {
                return "2016";
            }
            if ("14".equals(this.getVersion().getMajorAsString())) {
                return "2017";
            }
            if ("15".equals(this.getVersion().getMajorAsString())) {
                return "2019";
            }
            if ("16".equals(this.getVersion().getMajorAsString())) {
                return "2022";
            }
        }
        return super.computeVersionDisplayName(version);
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getMainSession().getJdbcTemplate().queryForString("SELECT SUSER_SNAME()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, this.getCloseQuote(), this.getEscapedQuote());
    }

    @Override
    public String doQuote(String identifier) {
        return this.getOpenQuote() + this.escapeIdentifier(identifier) + this.getCloseQuote();
    }

    @Override
    public String getOpenQuote() {
        return "[";
    }

    @Override
    public String getCloseQuote() {
        return "]";
    }

    @Override
    public String getEscapedQuote() {
        return "]]";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean usesSingleSession() {
        return true;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String filegroup = this.isAzure() || this.configuration.getTablespace() == null ? "" : " ON \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + table + " (\n    [installed_rank] INT NOT NULL,\n    [version] NVARCHAR(50),\n    [description] NVARCHAR(200),\n    [type] NVARCHAR(20) NOT NULL,\n    [script] NVARCHAR(1000) NOT NULL,\n    [checksum] NVARCHAR(100),\n    [installed_by] NVARCHAR(100) NOT NULL,\n    [installed_on] DATETIME NOT NULL DEFAULT GETDATE(),\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n)" + filegroup + ";\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT [" + table.getName() + "_pk] PRIMARY KEY ([installed_rank]);\nCREATE INDEX [" + table.getName() + "_s_idx] ON " + table + " ([success]);\nGO\n";
    }

    private boolean isAzure() {
        return this.getMainSession().isAzureConnection();
    }

    private SQLServerEngineEdition getEngineEdition() {
        return this.getMainSession().getEngineEdition();
    }

    @Override
    public SQLServerSession getMainSession() {
        return (SQLServerSession)super.getMainSession();
    }

    protected boolean supportsPartitions() {
        return this.isAzure() || SQLServerEngineEdition.ENTERPRISE.equals((Object)this.getEngineEdition()) || this.getVersion().isAtLeast("13");
    }

    protected boolean supportsSequences() {
        return this.getVersion().isAtLeast("11");
    }

    protected boolean supportsSynonyms() {
        return true;
    }

    protected boolean supportsRules() {
        return true;
    }

    protected boolean supportsTypes() {
        return true;
    }

    protected boolean supportsTriggers() {
        return true;
    }

    protected boolean supportsAssemblies() {
        return true;
    }
}

