/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.sqlite.SQLiteDatabase;
import migratedb.v1.core.internal.database.sqlite.SQLiteTable;

public class SQLiteSchema
extends BaseSchema {
    private static final Log LOG = Log.getLog(SQLiteSchema.class);
    private static final List<String> IGNORED_SYSTEM_TABLE_NAMES = List.of("android_metadata");

    SQLiteSchema(JdbcTemplate jdbcTemplate, SQLiteDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        try {
            this.doAllTables();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    protected boolean doCheckIfEmpty() {
        for (Table table : this.allTables()) {
            if (IGNORED_SYSTEM_TABLE_NAMES.contains(table.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doCreate() {
        LOG.info("SQLite does not support creating schemas. Schema not created: " + this.name);
    }

    protected List<SQLiteTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT tbl_name FROM " + this.getDatabase().quote(this.name) + ".sqlite_master WHERE type='table'", new String[0]);
        ArrayList<SQLiteTable> tables = new ArrayList<SQLiteTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new SQLiteTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public SQLiteTable getTable(String tableName) {
        return new SQLiteTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected SQLiteDatabase getDatabase() {
        return (SQLiteDatabase)super.getDatabase();
    }
}

