/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.spanner;

import java.sql.Connection;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.spanner.SpannerDatabase;
import migratedb.v1.core.internal.database.spanner.SpannerJdbcTemplate;
import migratedb.v1.core.internal.database.spanner.SpannerSchema;

public class SpannerSession
extends BaseSession {
    protected SpannerSession(SpannerDatabase database, Connection connection) {
        super(database, connection);
        this.jdbcTemplate = new SpannerJdbcTemplate(connection, database.getDatabaseType());
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() {
        return "";
    }

    @Override
    public SpannerSchema getSchema(String name) {
        return new SpannerSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public SpannerDatabase getDatabase() {
        return (SpannerDatabase)super.getDatabase();
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new MigrateDbException(e);
            throw rethrow;
        }
    }
}

