/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.spanner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.spanner.SpannerDatabase;
import migratedb.v1.core.internal.database.spanner.SpannerTable;

public class SpannerSchema
extends BaseSchema {
    private static final Log LOG = Log.getLog(SpannerSchema.class);

    public SpannerSchema(JdbcTemplate jdbcTemplate, SpannerDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() {
        return this.name.isEmpty();
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        try (Connection c = this.getDatabase().getNewRawConnection();){
            boolean bl;
            block12: {
                Statement s = c.createStatement();
                s.close();
                ResultSet tables = c.getMetaData().getTables("", "", null, null);
                try {
                    boolean bl2 = bl = !tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    @Override
    protected SpannerDatabase getDatabase() {
        return (SpannerDatabase)super.getDatabase();
    }

    @Override
    protected void doCreate() {
        LOG.info("Spanner does not support creating schemas. Schema not created: " + this.name);
    }

    protected List<SpannerTable> doAllTables() throws SQLException {
        ArrayList<SpannerTable> tablesList = new ArrayList<SpannerTable>();
        Connection c = this.jdbcTemplate.getConnection();
        ResultSet tablesRs = c.getMetaData().getTables("", "", null, null);
        while (tablesRs.next()) {
            tablesList.add(new SpannerTable(this.jdbcTemplate, this.getDatabase(), this, tablesRs.getString("TABLE_NAME")));
        }
        tablesRs.close();
        return tablesList;
    }

    @Override
    public Table getTable(String tableName) {
        return new SpannerTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

