/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.saphana;

import java.sql.Connection;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.saphana.SAPHANASession;

public class SAPHANADatabase
extends BaseDatabase {
    public SAPHANADatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected SAPHANASession doGetSession(Connection connection) {
        return new SAPHANASession(this, connection);
    }

    @Override
    public void ensureSupported() {
        if (this.isCloud()) {
            this.recommendMigrateDbUpgradeIfNecessaryForMajorVersion("4");
        } else {
            this.recommendMigrateDbUpgradeIfNecessaryForMajorVersion("2");
        }
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" VARCHAR(100),\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" TINYINT NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");\nCREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");";
    }

    private boolean isCloud() {
        return this.getMainSession().isCloudConnection();
    }

    @Override
    public SAPHANASession getMainSession() {
        return (SAPHANASession)super.getMainSession();
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

