/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.redshift.RedshiftSession;
import migratedb.v1.core.internal.util.StringUtils;

public class RedshiftDatabase
extends BaseDatabase {
    public RedshiftDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected RedshiftSession doGetSession(Connection connection) {
        return new RedshiftSession(this, connection);
    }

    @Override
    public final void ensureSupported() {
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    \"installed_rank\" INT NOT NULL SORTKEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" VARCHAR(100),\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT getdate(),\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getMainSession().getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll(identifier, this.getCloseQuote(), this.getEscapedQuote()) + this.getCloseQuote();
    }

    @Override
    public String getEscapedQuote() {
        return "\"\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean usesSingleSession() {
        return false;
    }
}

