/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.postgresql;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.jdbc.Result;
import migratedb.v1.core.api.internal.jdbc.Results;
import migratedb.v1.core.api.internal.sqlscript.Delimiter;
import migratedb.v1.core.internal.sqlscript.ParsedSqlStatement;

public class PostgreSQLCopyParsedStatement
extends ParsedSqlStatement {
    private static final Delimiter COPY_DELIMITER = new Delimiter("\\.", true);
    private final String copyData;

    public PostgreSQLCopyParsedStatement(int pos, int line, int col, String sql, String copyData) {
        super(pos, line, col, sql, COPY_DELIMITER, true);
        this.copyData = copyData;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate) {
        Object copyManager;
        Method copyManagerCopyInMethod;
        try {
            Connection connection = jdbcTemplate.getConnection();
            ClassLoader classLoader = connection.getClass().getClassLoader();
            Class<?> baseConnectionClass = classLoader.loadClass("org.postgresql.core.BaseConnection");
            Object baseConnection = connection.unwrap(baseConnectionClass);
            Class<?> copyManagerClass = classLoader.loadClass("org.postgresql.copy.CopyManager");
            Constructor<?> copyManagerConstructor = copyManagerClass.getConstructor(baseConnectionClass);
            copyManagerCopyInMethod = copyManagerClass.getMethod("copyIn", String.class, Reader.class);
            copyManager = copyManagerConstructor.newInstance(baseConnection);
        }
        catch (ReflectiveOperationException | RuntimeException | SQLException e) {
            throw new MigrateDbException("Unable to find PostgreSQL CopyManager class", e);
        }
        Results results = new Results();
        try {
            try {
                Long updateCount = (Long)copyManagerCopyInMethod.invoke(copyManager, this.getSql(), new StringReader(this.copyData));
                results.addResult(new Result(updateCount, null, null, this.getSql()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SQLException("Unable to execute COPY operation", e);
            }
        }
        catch (SQLException e) {
            jdbcTemplate.extractErrors(results, e);
        }
        return results;
    }
}

