/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.oracle;

import java.util.Map;
import migratedb.v1.core.api.ConfigPropertiesConverter;
import migratedb.v1.core.api.ConvertedProperties;
import migratedb.v1.core.api.ExtensionConfig;
import migratedb.v1.core.internal.configuration.ConfigUtils;

public final class OracleConfig
implements ExtensionConfig {
    public static final String ORACLE_SQLPLUS = "migratedb.oracle.sqlplus";
    public static final String ORACLE_SQLPLUS_WARN = "migratedb.oracle.sqlplusWarn";
    public static final String ORACLE_KERBEROS_CONFIG_FILE = "migratedb.oracle.kerberosConfigFile";
    public static final String ORACLE_KERBEROS_CACHE_FILE = "migratedb.oracle.kerberosCacheFile";
    public static final String ORACLE_WALLET_LOCATION = "migratedb.oracle.walletLocation";
    private boolean sqlplus;
    private boolean sqlplusWarn;
    private String kerberosConfigFile;
    private String kerberosCacheFile;
    private String walletLocation;

    public boolean isSqlplus() {
        return this.sqlplus;
    }

    public boolean isSqlplusWarn() {
        return this.sqlplusWarn;
    }

    public String getKerberosConfigFile() {
        return this.kerberosConfigFile;
    }

    public String getKerberosCacheFile() {
        return this.kerberosCacheFile;
    }

    public String getWalletLocation() {
        return this.walletLocation;
    }

    public void setSqlplus(boolean Sqlplus) {
        this.sqlplus = Sqlplus;
    }

    public OracleConfig sqlplus(boolean Sqlplus) {
        this.setSqlplus(Sqlplus);
        return this;
    }

    public void setSqlplusWarn(boolean SqlplusWarn) {
        this.sqlplusWarn = SqlplusWarn;
    }

    public OracleConfig sqlplusWarn(boolean SqlplusWarn) {
        this.setSqlplusWarn(SqlplusWarn);
        return this;
    }

    public void setKerberosConfigFile(String KerberosConfigFile) {
        this.kerberosConfigFile = KerberosConfigFile;
    }

    public OracleConfig kerberosConfigFile(String KerberosConfigFile) {
        this.setKerberosConfigFile(KerberosConfigFile);
        return this;
    }

    public void setKerberosCacheFile(String KerberosCacheFile) {
        this.kerberosCacheFile = KerberosCacheFile;
    }

    public OracleConfig kerberosCacheFile(String KerberosCacheFile) {
        this.setKerberosCacheFile(KerberosCacheFile);
        return this;
    }

    public void setWalletLocation(String WalletLocation) {
        this.walletLocation = WalletLocation;
    }

    public OracleConfig walletLocation(String WalletLocation) {
        this.setWalletLocation(WalletLocation);
        return this;
    }

    public static final class PropertiesConverter
    implements ConfigPropertiesConverter {
        public ConvertedProperties<OracleConfig> convert(Map<String, String> mutableProps) {
            String walletLocationProp;
            String kerberosCacheFile;
            String kerberosConfigFile;
            Boolean sqlplusWarnProp;
            OracleConfig config = new OracleConfig();
            Boolean sqlplusProp = ConfigUtils.removeBoolean(mutableProps, OracleConfig.ORACLE_SQLPLUS);
            if (sqlplusProp != null) {
                config.setSqlplus(sqlplusProp);
            }
            if ((sqlplusWarnProp = ConfigUtils.removeBoolean(mutableProps, OracleConfig.ORACLE_SQLPLUS_WARN)) != null) {
                config.setSqlplusWarn(sqlplusWarnProp);
            }
            if ((kerberosConfigFile = mutableProps.remove(OracleConfig.ORACLE_KERBEROS_CONFIG_FILE)) != null) {
                config.setKerberosConfigFile(kerberosConfigFile);
            }
            if ((kerberosCacheFile = mutableProps.remove(OracleConfig.ORACLE_KERBEROS_CACHE_FILE)) != null) {
                config.setKerberosCacheFile(kerberosCacheFile);
            }
            if ((walletLocationProp = mutableProps.remove(OracleConfig.ORACLE_WALLET_LOCATION)) != null) {
                config.setWalletLocation(walletLocationProp);
            }
            return new ConvertedProperties<OracleConfig>(OracleConfig.class, config);
        }
    }
}

