/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.mysql.tidb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.internal.database.mysql.MySQLDatabase;
import migratedb.v1.core.internal.database.mysql.MySQLSession;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class TiDBSession
extends MySQLSession {
    private static final String TIDB_TXN_MODE = "tidb_txn_mode";

    public TiDBSession(MySQLDatabase database, Connection connection) {
        super(database, connection);
    }

    private void setTidbTxnMode() {
        try {
            this.jdbcTemplate.execute("SET tidb_txn_mode=pessimistic", new Object[0]);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to set value for 'tidb_txn_mode' variable", e);
        }
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        this.setTidbTxnMode();
        return super.lock(table, callable);
    }

    @Override
    protected boolean canUseNamedLockTemplate() {
        return false;
    }
}

