/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.base.BaseDatabaseType;
import migratedb.v1.core.internal.database.mysql.MySQLDatabaseType;
import migratedb.v1.core.internal.database.mysql.MySQLSession;
import migratedb.v1.core.internal.database.mysql.mariadb.MariaDBDatabaseType;

public class MySQLDatabase
extends BaseDatabase {
    private static final Pattern MARIADB_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+(-\\d+)*-MariaDB(-\\w+)*");
    private static final Pattern MARIADB_WITH_MAXSCALE_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+(-\\d+)* (\\d+\\.\\d+)\\.\\d+(-\\d+)*-maxscale(-\\w+)*");
    private static final Pattern MYSQL_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+\\w*");
    private static final Log LOG = Log.getLog(MySQLDatabase.class);
    private final boolean pxcStrict;
    private final boolean gtidConsistencyEnforced;
    final boolean eventSchedulerQueryable;

    public MySQLDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.rawMainJdbcConnection, this.databaseType);
        this.pxcStrict = this.isMySQL() && MySQLDatabase.isRunningInPerconaXtraDBClusterWithStrictMode(jdbcTemplate);
        this.gtidConsistencyEnforced = this.isMySQL() && MySQLDatabase.isRunningInGTIDConsistencyMode(jdbcTemplate);
        this.eventSchedulerQueryable = this.isMySQL() || MySQLDatabase.isEventSchedulerQueryable(jdbcTemplate);
    }

    private static boolean isEventSchedulerQueryable(JdbcTemplate jdbcTemplate) {
        try {
            jdbcTemplate.queryForString("SELECT event_name FROM information_schema.events LIMIT 1", new String[0]);
            return true;
        }
        catch (SQLException e) {
            LOG.debug("Detected unqueryable MariaDB event scheduler, most likely due to it being OFF or DISABLED.");
            return false;
        }
    }

    static boolean isRunningInPerconaXtraDBClusterWithStrictMode(JdbcTemplate jdbcTemplate) {
        try {
            String pcx_strict_mode = jdbcTemplate.queryForString("select VARIABLE_VALUE from performance_schema.global_variables where variable_name = 'pxc_strict_mode'", new String[0]);
            if ("ENFORCING".equals(pcx_strict_mode) || "MASTER".equals(pcx_strict_mode)) {
                LOG.debug("Detected Percona XtraDB Cluster in strict mode");
                return true;
            }
        }
        catch (SQLException e) {
            LOG.debug("Unable to detect whether we are running in a Percona XtraDB Cluster. Assuming not to be.");
        }
        return false;
    }

    static boolean isRunningInGTIDConsistencyMode(JdbcTemplate jdbcTemplate) {
        try {
            String gtidConsistency = jdbcTemplate.queryForString("SELECT @@GLOBAL.ENFORCE_GTID_CONSISTENCY", new String[0]);
            if ("ON".equals(gtidConsistency)) {
                LOG.debug("Detected GTID consistency being enforced");
                return true;
            }
        }
        catch (SQLException e) {
            LOG.debug("Unable to detect whether database enforces GTID consistency. Assuming not.");
        }
        return false;
    }

    boolean isMySQL() {
        return this.databaseType instanceof MySQLDatabaseType;
    }

    boolean isMariaDB() {
        return this.databaseType instanceof MariaDBDatabaseType;
    }

    boolean isPxcStrict() {
        return this.pxcStrict;
    }

    protected boolean isCreateTableAsSelectAllowed() {
        return !this.pxcStrict && !this.gtidConsistencyEnforced;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String tablespace = this.configuration.getTablespace() == null ? "" : " TABLESPACE \"" + this.configuration.getTablespace() + "\"";
        Object baselineMarker = "";
        if (baseline) {
            baselineMarker = this.isCreateTableAsSelectAllowed() ? " AS SELECT     1 as \"installed_rank\",     '" + this.configuration.getBaselineVersion() + "' as \"version\",     '" + this.configuration.getBaselineDescription() + "' as \"description\",     '" + MigrationType.BASELINE + "' as \"type\",     '" + this.configuration.getBaselineDescription() + "' as \"script\",     NULL as \"checksum\",     '" + this.getInstalledBy() + "' as \"installed_by\",     CURRENT_TIMESTAMP as \"installed_on\",     0 as \"execution_time\",     TRUE as \"success\"\n" : ";\n" + this.getBaselineStatement(table);
        }
        return "CREATE TABLE " + table + " (\n    `installed_rank` INT NOT NULL,\n    `version` VARCHAR(50),\n    `description` VARCHAR(200) NOT NULL,\n    `type` VARCHAR(20) NOT NULL,\n    `script` VARCHAR(1000) NOT NULL,\n    `checksum` VARCHAR(100),\n    `installed_by` VARCHAR(100) NOT NULL,\n    `installed_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    `execution_time` INT NOT NULL,\n    `success` BOOL NOT NULL,\n    CONSTRAINT " + this.getConstraintName(table.getName()) + " PRIMARY KEY (`installed_rank`)\n)" + tablespace + " ENGINE=InnoDB" + (String)baselineMarker + ";\nCREATE INDEX `" + table.getName() + "_s_idx` ON " + table + " (`success`);";
    }

    protected String getConstraintName(String tableName) {
        return "`" + tableName + "_pk`";
    }

    @Override
    protected MySQLSession doGetSession(Connection connection) {
        return new MySQLSession(this, connection);
    }

    @Override
    protected Version determineVersion() {
        String selectVersionOutput = BaseDatabaseType.getSelectVersionOutput(this.rawMainJdbcConnection);
        if (this.databaseType instanceof MariaDBDatabaseType) {
            return MySQLDatabase.extractMariaDBVersionFromString(selectVersionOutput);
        }
        return MySQLDatabase.extractMySQLVersionFromString(selectVersionOutput);
    }

    static Version extractMySQLVersionFromString(String selectVersionOutput) {
        return MySQLDatabase.extractVersionFromString(selectVersionOutput, MYSQL_VERSION_PATTERN);
    }

    static Version extractMariaDBVersionFromString(String selectVersionOutput) {
        return MySQLDatabase.extractVersionFromString(selectVersionOutput, MARIADB_VERSION_PATTERN, MARIADB_WITH_MAXSCALE_VERSION_PATTERN);
    }

    private static Version extractVersionFromString(String versionString, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(versionString);
            if (!matcher.find()) continue;
            return Version.parse(matcher.group(1));
        }
        throw new MigrateDbException("Unable to determine version from '" + versionString + "'");
    }

    @Override
    public final void ensureSupported() {
        if (this.databaseType.getName().equals("TiDB")) {
            this.ensureDatabaseIsRecentEnough("5.0");
            this.recommendMigrateDbUpgradeIfNecessary("5.0");
            return;
        }
        this.ensureDatabaseIsRecentEnough("5.1");
        if (this.databaseType instanceof MariaDBDatabaseType) {
            this.recommendMigrateDbUpgradeIfNecessary("11.0");
        } else {
            this.recommendMigrateDbUpgradeIfNecessary("8.0");
        }
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getMainSession().getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String getOpenQuote() {
        return "`";
    }

    @Override
    public String getCloseQuote() {
        return "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean usesSingleSession() {
        return !this.pxcStrict;
    }
}

