/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.ignite.thin;

import java.sql.SQLException;
import java.util.UUID;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.jdbc.Results;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseTable;
import migratedb.v1.core.internal.database.ignite.thin.IgniteThinDatabase;
import migratedb.v1.core.internal.database.ignite.thin.IgniteThinSchema;

public class IgniteThinTable
extends BaseTable {
    private static final Log LOG = Log.getLog(IgniteThinTable.class);
    private final String tableLockString = UUID.randomUUID().toString();

    public IgniteThinTable(JdbcTemplate jdbcTemplate, IgniteThinDatabase database, IgniteThinSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.exists(null, this.getSchema(), this.getName(), new String[0]);
    }

    @Override
    protected void doLock() throws SQLException {
        if (this.lockDepth > 0) {
            return;
        }
        int retryCount = 0;
        do {
            try {
                if (this.insertLockingRow()) {
                    return;
                }
                ++retryCount;
                LOG.debug("Waiting for lock on " + this);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retryCount < 50);
        throw new MigrateDbException("Unable to obtain table lock - another MigrateDb instance may be running");
    }

    @Override
    protected void doUnlock() throws SQLException {
        if (this.lockDepth > 1) {
            return;
        }
        int competingLocksTaken = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this + " WHERE " + this.getDatabase().quote("version") + " != '" + this.tableLockString + "' AND " + this.getDatabase().quote("description") + " = 'migratedb-lock'", new String[0]);
        if (competingLocksTaken > 0) {
            throw new MigrateDbException("Internal error: on unlocking, a competing lock was found");
        }
        this.jdbcTemplate.executeStatement("DELETE FROM " + this + " WHERE " + this.getDatabase().quote("version") + " = '" + this.tableLockString + "' AND " + this.getDatabase().quote("description") + " = 'migratedb-lock'");
    }

    private boolean insertLockingRow() {
        Results results = this.jdbcTemplate.executeStatement("INSERT INTO " + this + " VALUES (-100, '" + this.tableLockString + "', 'migratedb-lock', '', '', 0, '', now(), 0, TRUE)");
        return results.getException() == null;
    }
}

