/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.derby;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.derby.DerbyDatabase;
import migratedb.v1.core.internal.database.derby.DerbySchema;

public class DerbySession
extends BaseSession {
    DerbySession(DerbyDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new DerbySchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public DerbyDatabase getDatabase() {
        return (DerbyDatabase)super.getDatabase();
    }
}

