/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.db2;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.db2.DB2Database;
import migratedb.v1.core.internal.database.db2.DB2Schema;

public class DB2Session
extends BaseSession {
    DB2Session(DB2Database database, Connection connection) {
        super(database, connection);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("select current_schema from sysibm.sysdummy1", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public DB2Schema getSchema(String name) {
        return new DB2Schema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public DB2Database getDatabase() {
        return (DB2Database)super.getDatabase();
    }
}

