/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.cockroachdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBDatabase;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBTable;

public class CockroachDBSchema
extends BaseSchema {
    final boolean cockroachDB1;
    final boolean hasSchemaSupport;

    public CockroachDBSchema(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, String name) {
        super(jdbcTemplate, database, name);
        this.cockroachDB1 = !database.getVersion().isAtLeast("2");
        this.hasSchemaSupport = this.getDatabase().supportsSchemas();
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(this::doExistsOnce);
    }

    private boolean doExistsOnce() throws SQLException {
        if (this.hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( SELECT 1 FROM information_schema.schemata WHERE schema_name=? )", this.name);
        }
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( SELECT 1 FROM pg_database WHERE datname=? )", this.name);
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(this::doEmptyOnce);
    }

    private boolean doEmptyOnce() throws SQLException {
        if (this.cockroachDB1) {
            return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables  WHERE table_schema=?  AND table_type='BASE TABLE')", this.name);
        }
        if (!this.hasSchemaSupport) {
            return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables   WHERE table_catalog=?  AND table_schema='public'  AND table_type='BASE TABLE' UNION ALL  SELECT 1  FROM information_schema.sequences   WHERE sequence_catalog=?  AND sequence_schema='public')", this.name, this.name);
        }
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables   WHERE table_schema=?  AND table_type='BASE TABLE' UNION ALL  SELECT 1  FROM information_schema.sequences   WHERE sequence_schema=?)", this.name, this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        new CockroachDBRetryingStrategy().execute(() -> {
            this.doCreateOnce();
            return null;
        });
    }

    protected void doCreateOnce() throws SQLException {
        if (this.hasSchemaSupport) {
            this.jdbcTemplate.execute("CREATE SCHEMA IF NOT EXISTS " + this.getDatabase().quote(this.name), new Object[0]);
        } else {
            this.jdbcTemplate.execute("CREATE DATABASE IF NOT EXISTS " + this.getDatabase().quote(this.name), new Object[0]);
        }
    }

    protected List<CockroachDBTable> doAllTables() throws SQLException {
        String query = this.cockroachDB1 || this.hasSchemaSupport ? "SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'" : "SELECT table_name FROM information_schema.tables WHERE table_catalog=? AND table_schema='public' AND table_type='BASE TABLE'";
        List<String> tableNames = this.jdbcTemplate.queryForStringList(query, this.name);
        ArrayList<CockroachDBTable> tables = new ArrayList<CockroachDBTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new CockroachDBTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new CockroachDBTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected CockroachDBDatabase getDatabase() {
        return (CockroachDBDatabase)super.getDatabase();
    }
}

