/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.cockroachdb;

import java.sql.Connection;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.DatabaseExecutionStrategy;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.ExecutionTemplate;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.internal.database.DefaultExecutionStrategy;
import migratedb.v1.core.internal.database.base.BaseDatabaseType;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBDatabase;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBParser;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import migratedb.v1.core.internal.database.cockroachdb.CockroachRetryingTransactionalExecutionTemplate;
import migratedb.v1.core.internal.parser.BaseParser;

public class CockroachDBDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "CockroachDB";
    }

    @Override
    public int getNullType() {
        return 0;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("PostgreSQL")) {
            String selectVersionQueryOutput = CockroachDBDatabaseType.getSelectVersionOutput(connection);
            return selectVersionQueryOutput.contains("CockroachDB");
        }
        return false;
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        return new CockroachDBDatabase(configuration, jdbcConnectionFactory);
    }

    @Override
    public BaseParser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new CockroachDBParser(configuration, parsingContext);
    }

    @Override
    public DatabaseExecutionStrategy createExecutionStrategy(Connection connection) {
        if (connection == null) {
            return new DefaultExecutionStrategy();
        }
        return new CockroachDBRetryingStrategy();
    }

    @Override
    public ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        return new CockroachRetryingTransactionalExecutionTemplate(connection, rollbackOnException);
    }
}

