/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.SQLException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseTable;
import migratedb.v1.core.internal.database.bigquery.BigQueryDatabase;
import migratedb.v1.core.internal.database.bigquery.BigQuerySchema;

public class BigQueryTable
extends BaseTable {
    private static final Log LOG = Log.getLog(BigQueryTable.class);

    BigQueryTable(JdbcTemplate jdbcTemplate, BigQueryDatabase database, BigQuerySchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        if (!this.getSchema().exists()) {
            return false;
        }
        return this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + this.getDatabase().quote(this.getSchema().getName()) + ".INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE' AND table_name=?", this.getName()) > 0;
    }

    @Override
    protected void doLock() throws SQLException {
        LOG.debug("Unable to lock " + this + " as BigQuery does not support locking. No concurrent migration supported.");
    }

    @Override
    protected void doUnlock() {
    }
}

