/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.bigquery.BigQueryDatabase;
import migratedb.v1.core.internal.database.bigquery.BigQueryJdbcTemplate;
import migratedb.v1.core.internal.database.bigquery.BigQuerySchema;
import migratedb.v1.core.internal.util.StringUtils;

public class BigQuerySession
extends BaseSession {
    private static final Pattern DEFAULT_DATASET_PATTERN = Pattern.compile("DefaultDataset=([a-zA-Z\\d]*);");

    BigQuerySession(BigQueryDatabase database, Connection connection) {
        super(database, connection);
        this.jdbcTemplate = new BigQueryJdbcTemplate(connection, database.getDatabaseType());
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        String defaultDataset = this.getJdbcClientOption("DefaultDataset");
        return StringUtils.hasText(defaultDataset) ? defaultDataset.trim() : null;
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) {
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        String defaultDataset = this.parseDefaultDatasetFromUrl();
        return StringUtils.hasText(defaultDataset) ? this.getSchema(defaultDataset.trim()) : null;
    }

    private String parseDefaultDatasetFromUrl() throws SQLException {
        String url = this.getJdbcConnection().getMetaData().getURL();
        Matcher matcher = DEFAULT_DATASET_PATTERN.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getJdbcClientOption(String option) throws SQLException {
        return this.getJdbcConnection().getClientInfo(option);
    }

    @Override
    public BigQuerySchema getSchema(String name) {
        return new BigQuerySchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public BigQueryDatabase getDatabase() {
        return (BigQueryDatabase)super.getDatabase();
    }
}

