/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.base;

import java.sql.SQLException;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public abstract class BaseSchema
implements Schema {
    private static final Log LOG = Log.getLog(BaseSchema.class);
    protected final JdbcTemplate jdbcTemplate;
    private final Database database;
    protected final String name;

    public BaseSchema(JdbcTemplate jdbcTemplate, Database database, String name) {
        this.jdbcTemplate = jdbcTemplate;
        this.database = database;
        this.name = name;
    }

    protected Database getDatabase() {
        return this.database;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to check whether schema " + this + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    @Override
    public final boolean isEmpty() {
        try {
            return this.doCheckIfEmpty();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to check whether schema " + this + " is empty", e);
        }
    }

    protected abstract boolean doCheckIfEmpty() throws SQLException;

    @Override
    public final void create() {
        try {
            LOG.info("Creating schema " + this + " ...");
            this.doCreate();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to create schema " + this, e);
        }
    }

    protected abstract void doCreate() throws SQLException;

    @Override
    public final List<? extends Table> allTables() {
        try {
            return this.doAllTables();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to retrieve all tables in schema " + this, e);
        }
    }

    protected abstract List<? extends Table> doAllTables() throws SQLException;

    public final String toString() {
        return this.getDatabase().quote(this.name);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseSchema other = (BaseSchema)o;
        return this.name.equals(other.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }
}

