/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.internal.jdbc.JdbcUtils;

public class DatabaseTypeRegisterImpl
implements DatabaseTypeRegister {
    private List<DatabaseType> registeredDatabaseTypesInPriorityOrder = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatabaseTypes(Collection<DatabaseType> databaseTypes) {
        DatabaseTypeRegisterImpl databaseTypeRegisterImpl = this;
        synchronized (databaseTypeRegisterImpl) {
            HashSet<DatabaseType> copy = new HashSet<DatabaseType>();
            copy.addAll(this.registeredDatabaseTypesInPriorityOrder);
            copy.addAll(databaseTypes);
            this.registeredDatabaseTypesInPriorityOrder = copy.stream().sorted(Comparator.comparing(DatabaseType::getPriority)).collect(Collectors.toUnmodifiableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DatabaseTypeRegisterImpl databaseTypeRegisterImpl = this;
        synchronized (databaseTypeRegisterImpl) {
            this.registeredDatabaseTypesInPriorityOrder = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatabaseType> getDatabaseTypes() {
        DatabaseTypeRegisterImpl databaseTypeRegisterImpl = this;
        synchronized (databaseTypeRegisterImpl) {
            return this.registeredDatabaseTypesInPriorityOrder;
        }
    }

    @Override
    public DatabaseType getDatabaseTypeForConnection(Connection connection) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        for (DatabaseType type : this.getDatabaseTypes()) {
            if (!type.handlesDatabaseProductNameAndVersion(databaseProductName, databaseProductVersion, connection)) continue;
            return type;
        }
        throw new MigrateDbException("Unsupported Database: " + databaseProductName);
    }
}

