/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.internal.sqlscript.SqlScriptMetadataImpl;

public final class ConfigUtils {
    public static Map<String, String> loadConfiguration(Reader reader) {
        try {
            return ConfigUtils.tryLoadConfig(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
        }
        catch (IOException e) {
            throw new MigrateDbException("Unable to read config", e);
        }
    }

    private static Map<String, String> tryLoadConfig(BufferedReader reader) throws IOException {
        String[] lines = (String[])reader.lines().toArray(String[]::new);
        StringBuilder confBuilder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            Object replacedLine = lines[i].trim().replace("\\", "\\\\");
            if (((String)replacedLine).endsWith("\\\\") && i < lines.length - 1) {
                String nextLine = lines[i + 1];
                boolean restoreMultilineDelimiter = false;
                if (!nextLine.isEmpty()) {
                    if (nextLine.trim().startsWith("migratedb.") && nextLine.contains("=")) {
                        if (SqlScriptMetadataImpl.isMultilineBooleanExpression(nextLine)) {
                            restoreMultilineDelimiter = true;
                        }
                    } else {
                        restoreMultilineDelimiter = true;
                    }
                }
                if (restoreMultilineDelimiter) {
                    replacedLine = ((String)replacedLine).substring(0, ((String)replacedLine).length() - 2) + "\\";
                }
            }
            confBuilder.append((String)replacedLine).append("\n");
        }
        String contents = confBuilder.toString();
        Properties properties = new Properties();
        properties.load(new StringReader(contents));
        return ConfigUtils.propertiesToMap(properties);
    }

    public static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    public static Boolean removeBoolean(Map<String, String> config, String key) {
        String value = config.remove(key);
        if (value == null) {
            return null;
        }
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new MigrateDbException("Invalid value for " + key + " (should be either true or false): " + value, ErrorCode.CONFIGURATION);
        }
        return Boolean.valueOf(value);
    }

    public static Integer removeInteger(Map<String, String> config, String key) {
        String value = config.remove(key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new MigrateDbException("Invalid value for " + key + " (should be an integer): " + value, ErrorCode.CONFIGURATION);
        }
    }

    public static void reportUnrecognisedProperties(Map<String, String> config, String prefix) {
        ArrayList<String> unknownMigrateDbProperties = new ArrayList<String>();
        for (String key : config.keySet()) {
            if (prefix != null && !key.startsWith(prefix)) continue;
            unknownMigrateDbProperties.add(key);
        }
        if (!unknownMigrateDbProperties.isEmpty()) {
            String property = unknownMigrateDbProperties.size() == 1 ? "property" : "properties";
            String message = String.format("Unknown configuration %s: %s", property, String.join((CharSequence)",", unknownMigrateDbProperties));
            throw new MigrateDbException(message, ErrorCode.CONFIGURATION);
        }
    }
}

