/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.command;

import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.output.BaselineResult;
import migratedb.v1.core.api.output.CommandResultFactory;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public class DbBaseline {
    private static final Log LOG = Log.getLog(DbBaseline.class);
    private final SchemaHistory schemaHistory;
    private final Version baselineVersion;
    private final String baselineDescription;
    private final CallbackExecutor callbackExecutor;
    private final BaselineResult baselineResult;

    public DbBaseline(SchemaHistory schemaHistory, Version baselineVersion, String baselineDescription, CallbackExecutor callbackExecutor, Database database) {
        this.schemaHistory = schemaHistory;
        this.baselineVersion = baselineVersion;
        this.baselineDescription = baselineDescription;
        this.callbackExecutor = callbackExecutor;
        this.baselineResult = CommandResultFactory.createBaselineResult(database.getCatalog());
    }

    public BaselineResult baseline() {
        block8: {
            this.callbackExecutor.onEvent(Event.BEFORE_BASELINE);
            try {
                if (!this.schemaHistory.exists()) {
                    this.schemaHistory.create(true);
                    LOG.info("Successfully baselined schema with version: " + this.baselineVersion);
                    this.baselineResult.successfullyBaselined = true;
                    this.baselineResult.baselineVersion = this.baselineVersion.toString();
                    break block8;
                }
                AppliedMigration baselineMarker = this.schemaHistory.getBaselineMarker();
                if (baselineMarker != null) {
                    if (this.baselineVersion.equals(baselineMarker.getVersion()) && this.baselineDescription.equals(baselineMarker.getDescription())) {
                        LOG.info("Schema history table " + this.schemaHistory + " already initialized with (" + this.baselineVersion + "," + this.baselineDescription + "). Skipping.");
                        this.baselineResult.successfullyBaselined = true;
                        this.baselineResult.baselineVersion = this.baselineVersion.toString();
                        break block8;
                    }
                    throw new MigrateDbException("Unable to baseline schema history table " + this.schemaHistory + " with (" + this.baselineVersion + "," + this.baselineDescription + ") as it has already been baselined with (" + baselineMarker.getVersion() + "," + baselineMarker.getDescription() + ")");
                }
                if (this.schemaHistory.hasSchemasMarker() && this.baselineVersion.equals(Version.parse("0"))) {
                    throw new MigrateDbException("Unable to baseline schema history table " + this.schemaHistory + " with version 0 as this version was used for schema creation");
                }
                if (this.schemaHistory.hasAppliedMigrations()) {
                    throw new MigrateDbException("Unable to baseline schema history table " + this.schemaHistory + " as it already contains migrations");
                }
                if (this.schemaHistory.allAppliedMigrations().isEmpty()) {
                    throw new MigrateDbException("Unable to baseline schema history table " + this.schemaHistory + " as it already exists, and is empty.");
                }
                throw new MigrateDbException("Unable to baseline schema history table " + this.schemaHistory + " as it already contains migrations.");
            }
            catch (MigrateDbException e) {
                this.callbackExecutor.onEvent(Event.AFTER_BASELINE_ERROR);
                this.baselineResult.successfullyBaselined = false;
                throw e;
            }
        }
        this.callbackExecutor.onEvent(Event.AFTER_BASELINE);
        return this.baselineResult;
    }
}

