/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.callback;

import java.sql.Connection;
import java.util.List;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.callback.Context;
import migratedb.v1.core.api.callback.Error;
import migratedb.v1.core.api.callback.Statement;
import migratedb.v1.core.api.callback.Warning;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.output.OperationResult;

public class SimpleContext
implements Context {
    private final Configuration configuration;
    private final Session session;
    private final MigrationInfo migrationInfo;
    private final Statement statement;
    private final OperationResult operationResult;

    SimpleContext(Configuration configuration, Session session, MigrationInfo migrationInfo, OperationResult operationResult) {
        this.configuration = configuration;
        this.session = session;
        this.migrationInfo = migrationInfo;
        this.operationResult = operationResult;
        this.statement = null;
    }

    public SimpleContext(Configuration configuration, Session session, MigrationInfo migrationInfo, String sql, List<Warning> warnings, List<Error> errors) {
        this.configuration = configuration;
        this.session = session;
        this.migrationInfo = migrationInfo;
        this.operationResult = null;
        this.statement = new SimpleStatement(sql, warnings, errors);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Connection getConnection() {
        return this.session.getJdbcConnection();
    }

    @Override
    public MigrationInfo getMigrationInfo() {
        return this.migrationInfo;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    private static class SimpleStatement
    implements Statement {
        private final String sql;
        private final List<Warning> warnings;
        private final List<Error> errors;

        private SimpleStatement(String sql, List<Warning> warnings, List<Error> errors) {
            this.sql = sql;
            this.warnings = warnings;
            this.errors = errors;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public List<Warning> getWarnings() {
            return this.warnings;
        }

        @Override
        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

