/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.output;

import java.util.List;
import java.util.stream.Collectors;
import migratedb.v1.core.api.ErrorDetails;
import migratedb.v1.core.api.output.OperationResult;
import migratedb.v1.core.api.output.ValidateOutput;

public class ValidateResult
extends OperationResult {
    public final ErrorDetails errorDetails;
    public final List<ValidateOutput> invalidMigrations;
    public final boolean validationSuccessful;
    public final int validateCount;

    public ValidateResult(String migratedbVersion, String database, ErrorDetails errorDetails, boolean validationSuccessful, int validateCount, List<ValidateOutput> invalidMigrations, List<String> warnings) {
        this.migratedbVersion = migratedbVersion;
        this.database = database;
        this.errorDetails = errorDetails;
        this.validationSuccessful = validationSuccessful;
        this.validateCount = validateCount;
        this.invalidMigrations = invalidMigrations;
        this.operation = "validate";
        warnings.forEach(this::addWarning);
    }

    public String getAllErrorMessages() {
        return this.invalidMigrations.stream().map(m -> m.errorDetails.errorMessage).collect(Collectors.joining("\n"));
    }
}

