/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.migration;

import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.internal.resolver.MigrationInfoHelper;

public abstract class BaseJavaMigration
implements JavaMigration {
    private final boolean isBaseline;
    private final boolean isRepeatable;
    private final Version version;
    private final String description;

    public BaseJavaMigration() {
        String shortName = this.getClass().getSimpleName();
        String prefix = null;
        this.isRepeatable = shortName.startsWith("R");
        this.isBaseline = shortName.startsWith("B");
        if (shortName.startsWith("V") || this.isBaseline || this.isRepeatable) {
            prefix = shortName.substring(0, 1);
        }
        if (prefix == null) {
            throw new MigrateDbException("Invalid Java-based migration class name: " + this.getClass().getName() + " => ensure it starts with V, R, B or implement JavaMigration directly for non-default naming");
        }
        MigrationInfoHelper.VersionAndDescription info = MigrationInfoHelper.extractVersionAndDescription(shortName, prefix, "__", this.isRepeatable);
        this.version = info.version;
        this.description = info.description;
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isBaselineMigration() {
        return this.isBaseline;
    }

    @Override
    public boolean canExecuteInTransaction() {
        return true;
    }
}

