/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.configuration;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.ConfigPropertiesConverter;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.ConvertedProperties;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.ExtensionConfig;
import migratedb.v1.core.api.Location;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrateDbExtension;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.configuration.FluentConfiguration;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.api.logging.LogSystems;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.pattern.ValidatePattern;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.configuration.ConfigUtils;
import migratedb.v1.core.internal.database.DatabaseTypeRegisterImpl;
import migratedb.v1.core.internal.extension.BuiltinFeatures;
import migratedb.v1.core.internal.util.ClassUtils;
import migratedb.v1.core.internal.util.Locations;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultConfiguration
implements Configuration {
    private @Nullable ConnectionProvider dataSource;
    private int connectRetries;
    private int connectRetriesInterval = 120;
    private String initSql;
    private final ClassLoader classLoader;
    private Locations locations;
    private Charset encoding = StandardCharsets.UTF_8;
    private String defaultSchemaName = null;
    private List<String> schemas = List.of();
    private String table = "migratedb_state";
    private String oldTable = "flyway_schema_history";
    private boolean liberateOnMigrate = true;
    private @Nullable String tablespace;
    private TargetVersion target;
    private boolean failOnMissingTarget = true;
    private List<MigrationPattern> cherryPick = List.of();
    private boolean placeholderReplacement = true;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String scriptPlaceholderPrefix = "FP__";
    private String scriptPlaceholderSuffix = "__";
    private String sqlMigrationPrefix = "V";
    private String baselineMigrationPrefix = "B";
    private String repeatableSqlMigrationPrefix = "R";
    private ResourceProvider resourceProvider = null;
    private ClassProvider<JavaMigration> javaMigrationClassProvider = null;
    private String sqlMigrationSeparator = "__";
    private List<String> sqlMigrationSuffixes = List.of(".sql");
    private List<JavaMigration> javaMigrations = List.of();
    private boolean ignoreMissingMigrations;
    private boolean ignoreIgnoredMigrations;
    private boolean ignorePendingMigrations;
    private boolean ignoreFutureMigrations = true;
    private List<ValidatePattern> ignoreMigrationPatterns = List.of();
    private boolean validateMigrationNaming = false;
    private boolean validateOnMigrate = true;
    private Version baselineVersion = Version.parse("1");
    private String baselineDescription = "<< MigrateDB Baseline >>";
    private boolean baselineOnMigrate;
    private boolean outOfOrder;
    private boolean skipExecutingMigrations;
    private List<Callback> callbacks = List.of();
    private boolean skipDefaultCallbacks;
    private List<MigrationResolver> resolvers = List.of();
    private boolean skipDefaultResolvers;
    private boolean mixed;
    private boolean group;
    private String installedBy;
    private boolean createSchemas = true;
    private boolean outputQueryResults = false;
    private int lockRetryCount = 50;
    private boolean failOnMissingLocations = false;
    private LogSystem logger;
    private final DatabaseTypeRegisterImpl databaseTypeRegister = new DatabaseTypeRegisterImpl();
    private final Set<MigrateDbExtension> loadedExtensions = new HashSet<MigrateDbExtension>();
    private final Map<Class<? extends ExtensionConfig>, ExtensionConfig> extensionConfig = new HashMap<Class<? extends ExtensionConfig>, ExtensionConfig>();

    public DefaultConfiguration() {
        this(ClassUtils.defaultClassLoader());
    }

    public DefaultConfiguration(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.defaultClassLoader() : classLoader;
        this.locations = new Locations(List.of("db/migration"), classLoader);
        this.useExtension(BuiltinFeatures.instance());
    }

    public DefaultConfiguration(Configuration configuration) {
        this(configuration.getClassLoader());
        this.configure(configuration);
    }

    public FluentConfiguration asFluentConfiguration() {
        return new FluentConfiguration(this);
    }

    @Override
    public List<Location> getLocations() {
        return this.locations.getLocations();
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchemaName;
    }

    @Override
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getOldTable() {
        return this.oldTable;
    }

    @Override
    public boolean isLiberateOnMigrate() {
        return this.liberateOnMigrate;
    }

    @Override
    public @Nullable String getTablespace() {
        return this.tablespace;
    }

    @Override
    public TargetVersion getTarget() {
        return this.target;
    }

    @Override
    public boolean isFailOnMissingTarget() {
        return this.failOnMissingTarget;
    }

    @Override
    public List<MigrationPattern> getCherryPick() {
        return this.cherryPick;
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    public String getScriptPlaceholderPrefix() {
        return this.scriptPlaceholderPrefix;
    }

    @Override
    public String getScriptPlaceholderSuffix() {
        return this.scriptPlaceholderSuffix;
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    @Override
    public String getBaselineMigrationPrefix() {
        return this.baselineMigrationPrefix;
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    @Override
    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    @Override
    public List<JavaMigration> getJavaMigrations() {
        return this.javaMigrations;
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    @Override
    public boolean isIgnoreIgnoredMigrations() {
        return this.ignoreIgnoredMigrations;
    }

    @Override
    public boolean isIgnorePendingMigrations() {
        return this.ignorePendingMigrations;
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    @Override
    public List<ValidatePattern> getIgnoreMigrationPatterns() {
        return this.ignoreMigrationPatterns;
    }

    @Override
    public boolean isValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    @Override
    public Version getBaselineVersion() {
        return this.baselineVersion;
    }

    @Override
    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    @Override
    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public boolean isSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    @Override
    public List<MigrationResolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    @Override
    public @Nullable ConnectionProvider getDataSource() {
        return this.dataSource;
    }

    @Override
    public int getConnectRetries() {
        return this.connectRetries;
    }

    @Override
    public int getConnectRetriesInterval() {
        return this.connectRetriesInterval;
    }

    @Override
    public String getInitSql() {
        return this.initSql;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isMixed() {
        return this.mixed;
    }

    @Override
    public String getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public int getLockRetryCount() {
        return this.lockRetryCount;
    }

    @Override
    public LogSystem getLogger() {
        return this.logger;
    }

    @Override
    public boolean isFailOnMissingLocations() {
        return this.failOnMissingLocations;
    }

    @Override
    public boolean isOutputQueryResults() {
        return this.outputQueryResults;
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.javaMigrationClassProvider;
    }

    @Override
    public boolean isCreateSchemas() {
        return this.createSchemas;
    }

    @Override
    public List<Callback> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    @Override
    public DatabaseTypeRegister getDatabaseTypeRegister() {
        return this.databaseTypeRegister;
    }

    @Override
    public Set<MigrateDbExtension> getLoadedExtensions() {
        return Collections.unmodifiableSet(this.loadedExtensions);
    }

    @Override
    public Map<Class<? extends ExtensionConfig>, ? extends ExtensionConfig> getExtensionConfig() {
        return Collections.unmodifiableMap(this.extensionConfig);
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.installedBy = installedBy;
    }

    public void setLogger(LogSystem logger) {
        this.logger = logger;
    }

    public void setLogger(String ... logger) {
        this.logger = LogSystems.fromStrings(new LinkedHashSet<String>(Arrays.asList(logger)), this.getClassLoader(), null);
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.ignoreMissingMigrations = ignoreMissingMigrations;
    }

    public void setIgnoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.ignoreIgnoredMigrations = ignoreIgnoredMigrations;
    }

    public void setIgnorePendingMigrations(boolean ignorePendingMigrations) {
        this.ignorePendingMigrations = ignorePendingMigrations;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.ignoreFutureMigrations = ignoreFutureMigrations;
    }

    public void setIgnoreMigrationPatternsAsStrings(String ... ignoreMigrationPatterns) {
        this.setIgnoreMigrationPatternsAsStrings(Arrays.asList(ignoreMigrationPatterns));
    }

    public void setIgnoreMigrationPatternsAsStrings(Collection<String> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = ignoreMigrationPatterns.stream().map(ValidatePattern::fromPattern).collect(Collectors.toUnmodifiableList());
    }

    public void setIgnoreMigrationPatterns(ValidatePattern ... ignoreMigrationPatterns) {
        this.setIgnoreMigrationPatterns(Arrays.asList(ignoreMigrationPatterns));
    }

    public void setIgnoreMigrationPatterns(Collection<ValidatePattern> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = List.copyOf(ignoreMigrationPatterns);
    }

    public void setValidateMigrationNaming(boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setLocationsAsStrings(String ... locations) {
        this.setLocationsAsStrings(Arrays.asList(locations));
    }

    public void setLocationsAsStrings(Collection<String> locations) {
        this.locations = new Locations(List.copyOf(locations), this.classLoader);
    }

    public void setLocations(Location ... locations) {
        this.setLocations(Arrays.asList(locations));
    }

    public void setLocations(Collection<Location> locations) {
        this.locations = new Locations(List.copyOf(locations));
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setEncodingAsString(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setDefaultSchema(String schema) {
        this.defaultSchemaName = schema;
    }

    public void setSchemas(String ... schemas) {
        this.setSchemas(Arrays.asList(schemas));
    }

    public void setSchemas(Collection<String> schemas) {
        this.schemas = List.copyOf(schemas);
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setOldTable(String oldTable) {
        this.oldTable = oldTable;
    }

    public void setTablespace(@Nullable String tablespace) {
        this.tablespace = tablespace;
    }

    public void setTarget(TargetVersion target) {
        this.target = target;
    }

    public void setTargetAsString(String target) {
        if (target.endsWith("?")) {
            this.setFailOnMissingTarget(false);
            this.setTarget(TargetVersion.parse(target.substring(0, target.length() - 1)));
        } else {
            this.setFailOnMissingTarget(true);
            this.setTarget(TargetVersion.parse(target));
        }
    }

    public void setFailOnMissingTarget(boolean failOnMissingTarget) {
        this.failOnMissingTarget = failOnMissingTarget;
    }

    public void setCherryPick(MigrationPattern ... cherryPick) {
        this.setCherryPick(Arrays.asList(cherryPick));
    }

    public void setCherryPick(Collection<MigrationPattern> cherryPick) {
        this.cherryPick = List.copyOf(cherryPick);
    }

    public void setCherryPickAsString(String ... cherryPickAsString) {
        this.setCherryPickAsString(Arrays.asList(cherryPickAsString));
    }

    public void setCherryPickAsString(Collection<String> cherryPickAsString) {
        this.cherryPick = cherryPickAsString.stream().map(MigrationPattern::new).collect(Collectors.toUnmodifiableList());
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new MigrateDbException("placeholderPrefix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        if (!StringUtils.hasLength(scriptPlaceholderPrefix)) {
            throw new MigrateDbException("scriptPlaceholderPrefix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.scriptPlaceholderPrefix = scriptPlaceholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new MigrateDbException("placeholderSuffix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        if (!StringUtils.hasLength(scriptPlaceholderSuffix)) {
            throw new MigrateDbException("scriptPlaceholderSuffix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.scriptPlaceholderSuffix = scriptPlaceholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setBaselineMigrationPrefix(String baselineMigrationPrefix) {
        this.baselineMigrationPrefix = baselineMigrationPrefix;
    }

    public void setJavaMigrations(JavaMigration ... javaMigrations) {
        this.javaMigrations = List.copyOf(Arrays.asList(javaMigrations));
    }

    public void setJavaMigrations(Collection<JavaMigration> javaMigrations) {
        this.javaMigrations = List.copyOf(javaMigrations);
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new MigrateDbException("sqlMigrationSeparator cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.setSqlMigrationSuffixes(Arrays.asList(sqlMigrationSuffixes));
    }

    public void setSqlMigrationSuffixes(Collection<String> sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = List.copyOf(sqlMigrationSuffixes);
    }

    public void setDataSource(final @Nullable DataSource dataSource) {
        this.dataSource = dataSource == null ? null : new ConnectionProvider(){

            @Override
            public Connection getConnection() throws SQLException {
                return dataSource.getConnection();
            }

            public String toString() {
                return "(" + dataSource + ")::getConnection";
            }
        };
    }

    public void setDataSource(@Nullable ConnectionProvider dataSource) {
        this.dataSource = dataSource;
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < 0) {
            throw new MigrateDbException("Invalid number of connectRetries (must be 0 or greater): " + connectRetries, ErrorCode.CONFIGURATION);
        }
        this.connectRetries = connectRetries;
    }

    public void setConnectRetriesInterval(int connectRetriesInterval) {
        if (connectRetriesInterval < 0) {
            throw new MigrateDbException("Invalid number for connectRetriesInterval (must be 0 or greater): " + connectRetriesInterval, ErrorCode.CONFIGURATION);
        }
        this.connectRetriesInterval = connectRetriesInterval;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public void setBaselineVersion(Version baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.baselineVersion = Version.parse(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public void setSkipExecutingMigrations(boolean skipExecutingMigrations) {
        this.skipExecutingMigrations = skipExecutingMigrations;
    }

    public void setCallbacks(Callback ... callbacks) {
        this.setCallbacks(Arrays.asList(callbacks));
    }

    public void setCallbacks(Collection<Callback> callbacks) {
        this.callbacks = List.copyOf(callbacks);
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.setCallbacksAsClassNames(Arrays.asList(callbacks));
    }

    public void setCallbacksAsClassNames(Collection<String> callbacks) {
        this.setCallbacks(ClassUtils.instantiateAll(callbacks, this.classLoader));
    }

    public void useExtension(MigrateDbExtension extension) {
        if (this.loadedExtensions.add(extension)) {
            this.databaseTypeRegister.registerDatabaseTypes(extension.getDatabaseTypes());
        }
    }

    public void useExtensions(Iterable<MigrateDbExtension> extensions) {
        for (MigrateDbExtension extension : extensions) {
            this.useExtension(extension);
        }
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.setResolvers(Arrays.asList(resolvers));
    }

    public void setResolvers(Collection<MigrationResolver> resolvers) {
        this.resolvers = List.copyOf(resolvers);
    }

    public void setResolversAsClassNames(String ... resolvers) {
        this.setResolversAsClassNames(Arrays.asList(resolvers));
    }

    public void setResolversAsClassNames(Collection<String> resolvers) {
        this.setResolvers(ClassUtils.instantiateAll(resolvers, this.classLoader));
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public void setCreateSchemas(boolean createSchemas) {
        this.createSchemas = createSchemas;
    }

    public void setOutputQueryResults(boolean outputQueryResults) {
        this.outputQueryResults = outputQueryResults;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void setJavaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.javaMigrationClassProvider = javaMigrationClassProvider;
    }

    public void setLockRetryCount(int lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public void setFailOnMissingLocations(boolean failOnMissingLocations) {
        this.failOnMissingLocations = failOnMissingLocations;
    }

    public void setLiberateOnMigrate(boolean liberateOnMigrate) {
        this.liberateOnMigrate = liberateOnMigrate;
    }

    public <T extends ExtensionConfig> void setExtensionConfig(Class<T> extensionConfigType, T value) {
        this.extensionConfig.put(extensionConfigType, value);
    }

    public void configure(Configuration configuration) {
        this.extensionConfig.clear();
        this.extensionConfig.putAll(configuration.getExtensionConfig());
        this.loadedExtensions.clear();
        this.loadedExtensions.addAll(configuration.getLoadedExtensions());
        this.databaseTypeRegister.clear();
        this.databaseTypeRegister.registerDatabaseTypes(configuration.getDatabaseTypeRegister().getDatabaseTypes());
        this.setBaselineDescription(configuration.getBaselineDescription());
        this.setBaselineMigrationPrefix(configuration.getBaselineMigrationPrefix());
        this.setBaselineOnMigrate(configuration.isBaselineOnMigrate());
        this.setBaselineVersion(configuration.getBaselineVersion());
        this.setCallbacks(configuration.getCallbacks());
        this.setCherryPick(configuration.getCherryPick());
        this.setConnectRetries(configuration.getConnectRetries());
        this.setConnectRetriesInterval(configuration.getConnectRetriesInterval());
        this.setDataSource(configuration.getDataSource());
        this.setDefaultSchema(configuration.getDefaultSchema());
        this.setEncoding(configuration.getEncoding());
        this.setFailOnMissingLocations(configuration.isFailOnMissingLocations());
        this.setFailOnMissingTarget(configuration.isFailOnMissingTarget());
        this.setGroup(configuration.isGroup());
        this.setIgnoreFutureMigrations(configuration.isIgnoreFutureMigrations());
        this.setIgnoreIgnoredMigrations(configuration.isIgnoreIgnoredMigrations());
        this.setIgnoreMigrationPatterns(configuration.getIgnoreMigrationPatterns());
        this.setIgnoreMissingMigrations(configuration.isIgnoreMissingMigrations());
        this.setIgnorePendingMigrations(configuration.isIgnorePendingMigrations());
        this.setInitSql(configuration.getInitSql());
        this.setInstalledBy(configuration.getInstalledBy());
        this.setJavaMigrationClassProvider(configuration.getJavaMigrationClassProvider());
        this.setJavaMigrations(configuration.getJavaMigrations());
        this.setLocations(configuration.getLocations());
        this.setLockRetryCount(configuration.getLockRetryCount());
        this.setLogger(configuration.getLogger());
        this.setMixed(configuration.isMixed());
        this.setOldTable(configuration.getOldTable());
        this.setLiberateOnMigrate(configuration.isLiberateOnMigrate());
        this.setOutOfOrder(configuration.isOutOfOrder());
        this.setOutputQueryResults(configuration.isOutputQueryResults());
        this.setPlaceholderPrefix(configuration.getPlaceholderPrefix());
        this.setPlaceholderReplacement(configuration.isPlaceholderReplacement());
        this.setPlaceholders(configuration.getPlaceholders());
        this.setPlaceholderSuffix(configuration.getPlaceholderSuffix());
        this.setRepeatableSqlMigrationPrefix(configuration.getRepeatableSqlMigrationPrefix());
        this.setResolvers(configuration.getResolvers());
        this.setResourceProvider(configuration.getResourceProvider());
        this.setSchemas(configuration.getSchemas());
        this.setScriptPlaceholderPrefix(configuration.getScriptPlaceholderPrefix());
        this.setScriptPlaceholderSuffix(configuration.getScriptPlaceholderSuffix());
        this.setCreateSchemas(configuration.isCreateSchemas());
        this.setSkipDefaultCallbacks(configuration.isSkipDefaultCallbacks());
        this.setSkipDefaultResolvers(configuration.isSkipDefaultResolvers());
        this.setSkipExecutingMigrations(configuration.isSkipExecutingMigrations());
        this.setSqlMigrationPrefix(configuration.getSqlMigrationPrefix());
        this.setSqlMigrationSeparator(configuration.getSqlMigrationSeparator());
        this.setSqlMigrationSuffixes(configuration.getSqlMigrationSuffixes());
        this.setTable(configuration.getTable());
        this.setTablespace(configuration.getTablespace());
        this.setTarget(configuration.getTarget());
        this.setValidateMigrationNaming(configuration.isValidateMigrationNaming());
        this.setValidateOnMigrate(configuration.isValidateOnMigrate());
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void configure(Map<String, String> props) {
        Boolean failOnMissingLocationsProp;
        String ignoreMigrationPatternsProp;
        Boolean createSchemasProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outputQueryResultsProp;
        Boolean skipExecutingMigrationsProp;
        Boolean outOfOrderProp;
        Integer lockRetryCount;
        String loggersProp;
        String cherryPickProp;
        String targetProp;
        Boolean validateMigrationNamingProp;
        Boolean ignoreFutureMigrationsProp;
        Boolean ignorePendingMigrationsProp;
        Boolean ignoreIgnoredMigrationsProp;
        Boolean ignoreMissingMigrationsProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        String tablespaceProp;
        Boolean liberateOnMigrateProp;
        String oldTableProp;
        String tableProp;
        String schemasProp;
        String defaultSchemaProp;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String baselineMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String scriptPlaceholderSuffixProp;
        String scriptPlaceholderPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        String locationsProp;
        String initSqlProp;
        Integer connectRetriesIntervalProp;
        Integer connectRetriesProp = ConfigUtils.removeInteger(props = new HashMap<String, String>(props), "migratedb.connectRetries");
        if (connectRetriesProp != null) {
            this.setConnectRetries(connectRetriesProp);
        }
        if ((connectRetriesIntervalProp = ConfigUtils.removeInteger(props, "migratedb.connectRetriesInterval")) != null) {
            this.setConnectRetriesInterval(connectRetriesIntervalProp);
        }
        if ((initSqlProp = props.remove("migratedb.initSql")) != null) {
            this.setInitSql(initSqlProp);
        }
        if ((locationsProp = props.remove("migratedb.locations")) != null) {
            this.setLocationsAsStrings(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderReplacementProp = ConfigUtils.removeBoolean(props, "migratedb.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("migratedb.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("migratedb.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((scriptPlaceholderPrefixProp = props.remove("migratedb.scriptPlaceholderPrefix")) != null) {
            this.setScriptPlaceholderPrefix(scriptPlaceholderPrefixProp);
        }
        if ((scriptPlaceholderSuffixProp = props.remove("migratedb.scriptPlaceholderSuffix")) != null) {
            this.setScriptPlaceholderSuffix(scriptPlaceholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("migratedb.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((baselineMigrationPrefixProp = props.remove("migratedb.baselineMigrationPrefix")) != null) {
            this.setBaselineMigrationPrefix(baselineMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("migratedb.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("migratedb.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("migratedb.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("migratedb.encoding")) != null) {
            this.setEncodingAsString(encodingProp);
        }
        if ((defaultSchemaProp = props.remove("migratedb.defaultSchema")) != null) {
            this.setDefaultSchema(defaultSchemaProp);
        }
        if ((schemasProp = props.remove("migratedb.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("migratedb.table")) != null) {
            this.setTable(tableProp);
        }
        if ((oldTableProp = props.remove("migratedb.oldTable")) != null) {
            this.setOldTable(oldTableProp);
        }
        if ((liberateOnMigrateProp = ConfigUtils.removeBoolean(props, "migratedb.createSchemas")) != null) {
            this.setLiberateOnMigrate(liberateOnMigrateProp);
        }
        if ((tablespaceProp = props.remove("migratedb.tablespace")) != null) {
            this.setTablespace(tablespaceProp);
        }
        if ((validateOnMigrateProp = ConfigUtils.removeBoolean(props, "migratedb.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("migratedb.baselineVersion")) != null) {
            this.setBaselineVersionAsString(baselineVersionProp);
        }
        if ((baselineDescriptionProp = props.remove("migratedb.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = ConfigUtils.removeBoolean(props, "migratedb.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((ignoreMissingMigrationsProp = ConfigUtils.removeBoolean(props, "migratedb.ignoreMissingMigrations")) != null) {
            this.setIgnoreMissingMigrations(ignoreMissingMigrationsProp);
        }
        if ((ignoreIgnoredMigrationsProp = ConfigUtils.removeBoolean(props, "migratedb.ignoreIgnoredMigrations")) != null) {
            this.setIgnoreIgnoredMigrations(ignoreIgnoredMigrationsProp);
        }
        if ((ignorePendingMigrationsProp = ConfigUtils.removeBoolean(props, "migratedb.ignorePendingMigrations")) != null) {
            this.setIgnorePendingMigrations(ignorePendingMigrationsProp);
        }
        if ((ignoreFutureMigrationsProp = ConfigUtils.removeBoolean(props, "migratedb.ignoreFutureMigrations")) != null) {
            this.setIgnoreFutureMigrations(ignoreFutureMigrationsProp);
        }
        if ((validateMigrationNamingProp = ConfigUtils.removeBoolean(props, "migratedb.validateMigrationNaming")) != null) {
            this.setValidateMigrationNaming(validateMigrationNamingProp);
        }
        if ((targetProp = props.remove("migratedb.target")) != null) {
            this.setTargetAsString(targetProp);
        }
        if ((cherryPickProp = props.remove("migratedb.cherryPick")) != null) {
            this.setCherryPickAsString(StringUtils.tokenizeToStringArray(cherryPickProp, ","));
        }
        if ((loggersProp = props.remove("migratedb.logger")) != null) {
            this.setLogger(StringUtils.tokenizeToStringArray(loggersProp, ","));
        }
        if ((lockRetryCount = ConfigUtils.removeInteger(props, "migratedb.lockRetryCount")) != null) {
            this.setLockRetryCount(lockRetryCount);
        }
        if ((outOfOrderProp = ConfigUtils.removeBoolean(props, "migratedb.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if ((skipExecutingMigrationsProp = ConfigUtils.removeBoolean(props, "migratedb.skipExecutingMigrations")) != null) {
            this.setSkipExecutingMigrations(skipExecutingMigrationsProp);
        }
        if ((outputQueryResultsProp = ConfigUtils.removeBoolean(props, "migratedb.outputQueryResults")) != null) {
            this.setOutputQueryResults(outputQueryResultsProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("migratedb.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = ConfigUtils.removeBoolean(props, "migratedb.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("migratedb.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = ConfigUtils.removeBoolean(props, "migratedb.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        this.putPropertiesUnderNamespace(props, this.placeholders, "migratedb.placeholders.");
        Boolean mixedProp = ConfigUtils.removeBoolean(props, "migratedb.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = ConfigUtils.removeBoolean(props, "migratedb.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("migratedb.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((createSchemasProp = ConfigUtils.removeBoolean(props, "migratedb.createSchemas")) != null) {
            this.setCreateSchemas(createSchemasProp);
        }
        if ((ignoreMigrationPatternsProp = props.remove("migratedb.ignoreMigrationPatterns")) != null) {
            this.setIgnoreMigrationPatternsAsStrings(StringUtils.tokenizeToStringArray(ignoreMigrationPatternsProp, ","));
        }
        if ((failOnMissingLocationsProp = ConfigUtils.removeBoolean(props, "migratedb.failOnMissingLocations")) != null) {
            this.setFailOnMissingLocations(failOnMissingLocationsProp);
        }
        for (MigrateDbExtension extension : this.loadedExtensions) {
            for (ConfigPropertiesConverter converter : extension.getConfigPropertiesConverters()) {
                ConvertedProperties<?> result = converter.convert(props);
                this.extensionConfig.put(result.extensionConfigType, (ExtensionConfig)result.config);
            }
        }
        ConfigUtils.reportUnrecognisedProperties(props, "migratedb.");
    }

    private void putPropertiesUnderNamespace(Map<String, String> properties, Map<String, String> target, String namespace) {
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith(namespace) || propertyName.length() <= namespace.length()) continue;
            String placeholderName = propertyName.substring(namespace.length());
            String placeholderValue = entry.getValue();
            target.put(placeholderName, placeholderValue);
            iterator.remove();
        }
    }
}

