/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.configuration;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.ExtensionConfig;
import migratedb.v1.core.api.Location;
import migratedb.v1.core.api.MigrateDbExtension;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.pattern.ValidatePattern;
import migratedb.v1.core.api.resolver.MigrationResolver;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Configuration {
    public ClassLoader getClassLoader();

    public @Nullable ConnectionProvider getDataSource();

    public int getConnectRetries();

    public int getConnectRetriesInterval();

    public String getInitSql();

    public Version getBaselineVersion();

    public String getBaselineDescription();

    public List<MigrationResolver> getResolvers();

    public boolean isSkipDefaultResolvers();

    public List<Callback> getCallbacks();

    public boolean isSkipDefaultCallbacks();

    public String getSqlMigrationPrefix();

    public String getBaselineMigrationPrefix();

    public String getRepeatableSqlMigrationPrefix();

    public String getSqlMigrationSeparator();

    public List<String> getSqlMigrationSuffixes();

    public List<JavaMigration> getJavaMigrations();

    public boolean isPlaceholderReplacement();

    public String getPlaceholderSuffix();

    public String getPlaceholderPrefix();

    public String getScriptPlaceholderSuffix();

    public String getScriptPlaceholderPrefix();

    public Map<String, String> getPlaceholders();

    public TargetVersion getTarget();

    public boolean isFailOnMissingTarget();

    public List<MigrationPattern> getCherryPick();

    public String getTable();

    public String getOldTable();

    public boolean isLiberateOnMigrate();

    public @Nullable String getTablespace();

    public String getDefaultSchema();

    public List<String> getSchemas();

    public Charset getEncoding();

    public List<Location> getLocations();

    public boolean isBaselineOnMigrate();

    public boolean isSkipExecutingMigrations();

    public boolean isOutOfOrder();

    public boolean isIgnoreMissingMigrations();

    public boolean isIgnoreIgnoredMigrations();

    public boolean isIgnorePendingMigrations();

    public boolean isIgnoreFutureMigrations();

    public List<ValidatePattern> getIgnoreMigrationPatterns();

    public boolean isValidateMigrationNaming();

    public boolean isValidateOnMigrate();

    public boolean isMixed();

    public boolean isGroup();

    public String getInstalledBy();

    public boolean isOutputQueryResults();

    public ResourceProvider getResourceProvider();

    public ClassProvider<JavaMigration> getJavaMigrationClassProvider();

    public boolean isCreateSchemas();

    public int getLockRetryCount();

    public boolean isFailOnMissingLocations();

    public LogSystem getLogger();

    public DatabaseTypeRegister getDatabaseTypeRegister();

    public Set<MigrateDbExtension> getLoadedExtensions();

    public Map<Class<? extends ExtensionConfig>, ? extends ExtensionConfig> getExtensionConfig();

    default public <T extends ExtensionConfig> @Nullable T getExtensionConfig(Class<T> type) {
        return (T)((ExtensionConfig)type.cast(this.getExtensionConfig().get(type)));
    }
}

