/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

public enum MigrationType {
    SCHEMA(true, false),
    BASELINE(true, false),
    DELETED(true, false),
    SQL(false, false),
    SQL_BASELINE(false, true),
    JDBC(false, false),
    JDBC_BASELINE(false, true);

    private final boolean isExclusiveToAppliedMigrations;
    private final boolean baselineMigration;

    private MigrationType(boolean isExclusiveToAppliedMigrations, boolean baselineMigration) {
        this.isExclusiveToAppliedMigrations = isExclusiveToAppliedMigrations;
        this.baselineMigration = baselineMigration;
    }

    public static MigrationType fromString(String migrationType) {
        if ("SPRING_JDBC".equals(migrationType)) {
            return JDBC;
        }
        if ("SQL_STATE_SCRIPT".equals(migrationType)) {
            return SQL_BASELINE;
        }
        if ("JDBC_STATE_SCRIPT".equals(migrationType)) {
            return JDBC_BASELINE;
        }
        if ("DELETE".equals(migrationType)) {
            return DELETED;
        }
        return MigrationType.valueOf(migrationType);
    }

    public boolean isExclusiveToAppliedMigrations() {
        return this.isExclusiveToAppliedMigrations;
    }

    public boolean isBaselineMigration() {
        return this.baselineMigration;
    }
}

