/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.util.Arrays;
import java.util.EnumSet;

public enum MigrationState {
    PENDING("Pending", Category.RESOLVED),
    ABOVE_TARGET("Above Target", Category.RESOLVED),
    BELOW_BASELINE("Below Baseline", Category.RESOLVED),
    BASELINE("Baseline", Category.RESOLVED, Category.APPLIED),
    IGNORED("Ignored", Category.RESOLVED),
    MISSING_SUCCESS("Missing", Category.APPLIED, Category.MISSING),
    MISSING_FAILED("Failed (Missing)", Category.APPLIED, Category.FAILED, Category.MISSING),
    SUCCESS("Success", Category.RESOLVED, Category.APPLIED),
    FAILED("Failed", Category.RESOLVED, Category.APPLIED, Category.FAILED),
    OUT_OF_ORDER("Out of Order", Category.RESOLVED, Category.APPLIED),
    FUTURE_SUCCESS("Future", Category.APPLIED, Category.FUTURE),
    FUTURE_FAILED("Failed (Future)", Category.APPLIED, Category.FUTURE, Category.FAILED),
    OUTDATED("Outdated", Category.RESOLVED, Category.APPLIED),
    SUPERSEDED("Superseded", Category.RESOLVED, Category.APPLIED),
    DELETED("Deleted", Category.APPLIED);

    private final String displayName;
    private final EnumSet<Category> categories;

    private MigrationState(String displayName, Category ... categories) {
        this.displayName = displayName;
        this.categories = EnumSet.noneOf(Category.class);
        this.categories.addAll(Arrays.asList(categories));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean is(Category category) {
        return this.categories.contains((Object)category);
    }

    public static enum Category {
        RESOLVED,
        APPLIED,
        FAILED,
        FUTURE,
        MISSING;

    }
}

