/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.internal.resource.classpath.ClassPathResourceProvider;
import migratedb.v1.core.internal.resource.filesystem.FileSystemResourceProvider;
import migratedb.v1.core.internal.util.ClassUtils;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Location {
    private Location() {
    }

    public static Location parse(String locationString, @Nullable ClassLoader classLoader) {
        if (locationString.startsWith("filesystem:")) {
            Path baseDirectory = Paths.get(locationString.substring("filesystem:".length()), new String[0]);
            return new FileSystemLocation(baseDirectory);
        }
        if (locationString.startsWith("custom:")) {
            String providerClass = locationString.substring("custom:".length());
            return CustomLocation.fromClass(providerClass, classLoader);
        }
        String packageName = locationString.startsWith("classpath:") ? locationString.substring("classpath:".length()) : locationString;
        return new ClassPathLocation(packageName, classLoader);
    }

    public abstract ResourceProvider resourceProvider();

    public abstract ClassProvider<?> classProvider();

    public abstract boolean exists();

    public abstract String toString();

    public static final class FileSystemLocation
    extends Location {
        public static final String PREFIX = "filesystem:";
        private final Path baseDirectory;

        public FileSystemLocation(Path baseDirectory) {
            this.baseDirectory = baseDirectory.toAbsolutePath().normalize();
        }

        @Override
        public ResourceProvider resourceProvider() {
            return new FileSystemResourceProvider(this.baseDirectory);
        }

        @Override
        public ClassProvider<?> classProvider() {
            return ClassProvider.noClasses();
        }

        @Override
        public boolean exists() {
            return Files.isDirectory(this.baseDirectory, new LinkOption[0]);
        }

        public Path getBaseDirectory() {
            return this.baseDirectory;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FileSystemLocation)) {
                return false;
            }
            FileSystemLocation other = (FileSystemLocation)o;
            return this.baseDirectory.equals(other.baseDirectory);
        }

        public int hashCode() {
            return this.baseDirectory.hashCode();
        }

        @Override
        public String toString() {
            return PREFIX + this.baseDirectory;
        }
    }

    public static final class CustomLocation
    extends Location {
        public static final String PREFIX = "custom:";
        private final ClassProvider<?> classProvider;
        private final ResourceProvider resourceProvider;

        public static CustomLocation fromClass(String className, @Nullable ClassLoader classLoader) {
            Object providerInstance = ClassUtils.instantiate(className, classLoader);
            String errorPrefix = "Location 'custom:" + className + "' must implement ";
            if (!(providerInstance instanceof ClassProvider)) {
                throw new MigrateDbException(errorPrefix + ClassProvider.class.getName());
            }
            if (!(providerInstance instanceof ResourceProvider)) {
                throw new MigrateDbException(errorPrefix + ResourceProvider.class.getName());
            }
            return new CustomLocation((ClassProvider)providerInstance, (ResourceProvider)providerInstance);
        }

        public CustomLocation(ClassProvider<?> classProvider, ResourceProvider resourceProvider) {
            this.classProvider = classProvider;
            this.resourceProvider = resourceProvider;
        }

        @Override
        public ResourceProvider resourceProvider() {
            return this.resourceProvider;
        }

        @Override
        public ClassProvider<?> classProvider() {
            return this.classProvider;
        }

        @Override
        public boolean exists() {
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CustomLocation)) {
                return false;
            }
            CustomLocation other = (CustomLocation)o;
            return this.resourceProvider.equals(other.resourceProvider) && this.classProvider.equals(other.classProvider);
        }

        public int hashCode() {
            return Objects.hash(this.resourceProvider, this.classProvider);
        }

        @Override
        public String toString() {
            return PREFIX + this.classProvider.getClass().getName();
        }
    }

    public static final class ClassPathLocation
    extends Location {
        public static final String PREFIX = "classpath:";
        public static final String RESOURCE_LIST_RESOURCE_NAME = "migratedb-resources.index";
        public static final String CLASS_LIST_RESOURCE_NAME = "migratedb-classes.index";
        private final String namePrefixWithTrailingSlash;
        private final ClassLoader classLoader;

        public ClassPathLocation(String namePrefix, @Nullable ClassLoader classLoader) {
            String trimmed = StringUtils.trimChar(namePrefix, '/');
            this.namePrefixWithTrailingSlash = trimmed + "/";
            this.classLoader = classLoader == null ? ClassUtils.defaultClassLoader() : classLoader;
        }

        public String namePrefix() {
            return StringUtils.trimChar(this.namePrefixWithTrailingSlash, '/');
        }

        @Override
        public ResourceProvider resourceProvider() {
            return new ClassPathResourceProvider(this.classLoader, this.readLines(RESOURCE_LIST_RESOURCE_NAME));
        }

        @Override
        public ClassProvider<?> classProvider() {
            return new ClassProvider<Object>(){
                private final List<Class<?>> classes;
                {
                    this.classes = this.readLines(ClassPathLocation.CLASS_LIST_RESOURCE_NAME).stream().map(it -> ClassUtils.loadClass(it, classLoader)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
                }

                @Override
                public Collection<Class<?>> getClasses() {
                    return this.classes;
                }
            };
        }

        @Override
        public boolean exists() {
            return this.classLoader.getResource(this.namePrefixWithTrailingSlash + RESOURCE_LIST_RESOURCE_NAME) != null || this.classLoader.getResource(this.namePrefixWithTrailingSlash + CLASS_LIST_RESOURCE_NAME) != null;
        }

        private List<String> readLines(String relativeResourceName) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                for (URL resource : Collections.list(this.classLoader.getResources(this.namePrefixWithTrailingSlash + relativeResourceName))) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                        ((Stream)reader.lines().sequential()).forEach(result::add);
                    }
                }
                return result;
            }
            catch (IOException e) {
                throw new MigrateDbException(e);
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassPathLocation)) {
                return false;
            }
            ClassPathLocation other = (ClassPathLocation)o;
            return this.namePrefixWithTrailingSlash.equals(other.namePrefixWithTrailingSlash) && this.classLoader.equals(other.classLoader);
        }

        public int hashCode() {
            return Objects.hash(this.namePrefixWithTrailingSlash, this.classLoader);
        }

        @Override
        public String toString() {
            return PREFIX + this.namePrefix();
        }
    }
}

