/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Checksum {
    private final byte[] bytes;

    private Checksum(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Checksum)) {
            return false;
        }
        Checksum other = (Checksum)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public static Checksum parse(String string) {
        return new Checksum(Base64.getDecoder().decode(string));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final MessageDigest digest = Builder.newMessageDigest();
        private byte counter = 0;
        private static final OutputStream discardingOutputStream = new OutputStream(){

            @Override
            public void write(byte[] b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
            }

            @Override
            public void write(int b) {
            }
        };

        public Builder addBytes(byte @Nullable [] value) {
            return this.add(value);
        }

        public Builder addBytes(@Nullable InputStream value) {
            return this.add(value);
        }

        public Builder addString(@Nullable String value) {
            return this.add(value == null ? null : value.getBytes(StandardCharsets.UTF_8));
        }

        public Builder addLines(@Nullable Reader value) {
            return this.add(value == null ? Collections.emptyIterator() : Builder.utf8LinesOf(value));
        }

        public Builder addNumber(@Nullable BigInteger value) {
            return this.add(value == null ? null : value.toByteArray());
        }

        public Builder addNumber(@Nullable Long value) {
            return this.addNumber(value == null ? null : BigInteger.valueOf(value));
        }

        public Checksum build() {
            Checksum checksum = new Checksum(this.digest.digest());
            this.counter = 0;
            return checksum;
        }

        private Builder add(Iterator<byte[]> bytes) {
            byte by = this.counter;
            this.counter = (byte)(by + 1);
            this.digest.update(by);
            while (bytes.hasNext()) {
                this.digest.update(bytes.next());
            }
            return this;
        }

        private Builder add(@Nullable InputStream bytes) {
            byte by = this.counter;
            this.counter = (byte)(by + 1);
            this.digest.update(by);
            if (bytes != null) {
                try (DigestOutputStream out = new DigestOutputStream(discardingOutputStream, this.digest);){
                    bytes.transferTo(out);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        private Builder add(byte @Nullable [] bytes) {
            return this.add(bytes == null ? Collections.emptyIterator() : List.of(bytes).iterator());
        }

        private static Iterator<byte[]> utf8LinesOf(Reader reader) {
            BufferedReader buffered = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            return buffered.lines().map(it -> it.getBytes(StandardCharsets.UTF_8)).iterator();
        }

        private static MessageDigest newMessageDigest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ignored) {
                throw new AssertionError();
            }
        }
    }
}

