/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core;

import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.callback.DefaultCallbackExecutor;
import migratedb.v1.core.internal.callback.NoopCallbackExecutor;
import migratedb.v1.core.internal.callback.SqlScriptCallbackFactory;
import migratedb.v1.core.internal.configuration.ConfigurationValidator;
import migratedb.v1.core.internal.jdbc.JdbcConnectionFactoryImpl;
import migratedb.v1.core.internal.parser.ParsingContextImpl;
import migratedb.v1.core.internal.resolver.DefaultMigrationResolver;
import migratedb.v1.core.internal.resource.ResourceNameValidator;
import migratedb.v1.core.internal.resource.StringResource;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;
import migratedb.v1.core.internal.schemahistory.SchemaHistoryFactory;
import migratedb.v1.core.internal.util.LocationScanner;

final class MigrateDbExecutor {
    private static final Log LOG = Log.getLog(MigrateDbExecutor.class);
    private final ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private final ResourceNameValidator resourceNameValidator = new ResourceNameValidator();
    private boolean dbConnectionInfoPrinted;
    private final Configuration configuration;

    MigrateDbExecutor(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T> T execute(Command<T> command, boolean scannerRequired) {
        LogSystem logSystem = this.configuration.getLogger();
        if (logSystem != null) {
            return (T)Log.withLogSystem(logSystem, () -> this.doExecute(command, scannerRequired));
        }
        return this.doExecute(command, scannerRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doExecute(Command<T> command, boolean scannerRequired) {
        T result;
        this.configurationValidator.validate(this.configuration);
        ResourceAndClassProviders resourceProviderClassProviders = this.createResourceAndClassProviders(scannerRequired);
        ResourceProvider resourceProvider = resourceProviderClassProviders.resourceProvider;
        ClassProvider<JavaMigration> classProvider = resourceProviderClassProviders.classProvider;
        this.resourceNameValidator.validateSQLMigrationNaming(resourceProvider, this.configuration);
        try (JdbcConnectionFactoryImpl jdbcConnectionFactory = new JdbcConnectionFactoryImpl(this.configuration.getDataSource(), this.configuration);){
            DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
            ParsingContextImpl parsingContext = new ParsingContextImpl();
            SqlScriptFactory sqlScriptFactory = databaseType.createSqlScriptFactory(this.configuration, parsingContext);
            SqlScriptExecutorFactory noCallbackSqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE);
            jdbcConnectionFactory.setConnectionInitializer((jdbcConnectionFactory1, connection) -> {
                if (this.configuration.getInitSql() == null) {
                    return;
                }
                StringResource resource = new StringResource("", this.configuration.getInitSql());
                SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, true, resourceProvider);
                boolean outputQueryResults = this.configuration.isOutputQueryResults();
                noCallbackSqlScriptExecutorFactory.createSqlScriptExecutor(connection, outputQueryResults).execute(sqlScript);
            });
            try (Database database = databaseType.createDatabase(this.configuration, !this.dbConnectionInfoPrinted, jdbcConnectionFactory);){
                this.dbConnectionInfoPrinted = true;
                LOG.debug("DDL transactions supported: " + database.supportsDdlTransactions());
                SchemaHistoryFactory.SchemasWithDefault schemas = SchemaHistoryFactory.scanSchemas(this.configuration, database);
                parsingContext.populate(database, this.configuration);
                database.ensureSupported();
                DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, schemas.defaultSchema, this.prepareCallbacks(resourceProvider, jdbcConnectionFactory, sqlScriptFactory));
                SqlScriptExecutorFactory sqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor);
                SchemaHistory schemaHistory = SchemaHistoryFactory.getSchemaHistory(this.configuration, noCallbackSqlScriptExecutorFactory, sqlScriptFactory, database, schemas.defaultSchema);
                CommandContext commandContext = new CommandContext(this.createMigrationResolver(resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext), schemaHistory, database, schemas.defaultSchema, schemas.all.toArray(new Schema[0]), callbackExecutor);
                result = command.execute(commandContext);
            }
            finally {
                this.showMemoryUsage();
            }
        }
        return result;
    }

    private ResourceAndClassProviders createResourceAndClassProviders(boolean scannerRequired) {
        ClassProvider<JavaMigration> classProvider;
        ResourceProvider resourceProvider;
        if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
            resourceProvider = ResourceProvider.noResources();
            classProvider = ClassProvider.noClasses();
        } else if (this.configuration.getResourceProvider() != null && this.configuration.getJavaMigrationClassProvider() != null) {
            resourceProvider = this.configuration.getResourceProvider();
            classProvider = this.configuration.getJavaMigrationClassProvider();
        } else {
            LocationScanner<JavaMigration> scanner;
            resourceProvider = scanner = new LocationScanner<JavaMigration>(JavaMigration.class, this.configuration.getLocations(), this.configuration.getClassLoader(), this.configuration.isFailOnMissingLocations());
            classProvider = scanner;
            if (this.configuration.getResourceProvider() != null) {
                resourceProvider = this.configuration.getResourceProvider();
            }
            if (this.configuration.getJavaMigrationClassProvider() != null) {
                classProvider = this.configuration.getJavaMigrationClassProvider();
            }
        }
        return new ResourceAndClassProviders(resourceProvider, classProvider);
    }

    private List<Callback> prepareCallbacks(ResourceProvider resourceProvider, JdbcConnectionFactory jdbcConnectionFactory, SqlScriptFactory sqlScriptFactory) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>(this.configuration.getCallbacks());
        if (!this.configuration.isSkipDefaultCallbacks()) {
            SqlScriptExecutorFactory sqlScriptExecutorFactory = jdbcConnectionFactory.getDatabaseType().createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE);
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, this.configuration).getCallbacks());
        }
        return effectiveCallbacks;
    }

    private MigrationResolver createMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext) {
        return new DefaultMigrationResolver(resourceProvider, classProvider, this.configuration, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, this.configuration.getResolvers());
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = total / 0x100000L;
        long usedMB = used / 0x100000L;
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    static interface Command<T> {
        public T execute(CommandContext var1);
    }

    private static final class ResourceAndClassProviders {
        public final ResourceProvider resourceProvider;
        public final ClassProvider<JavaMigration> classProvider;

        private ResourceAndClassProviders(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider) {
            this.resourceProvider = resourceProvider;
            this.classProvider = classProvider;
        }
    }

    static final class CommandContext {
        public final MigrationResolver migrationResolver;
        public final SchemaHistory schemaHistory;
        public final Database database;
        public final Schema defaultSchema;
        public final Schema[] schemas;
        public final CallbackExecutor callbackExecutor;

        CommandContext(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor) {
            this.migrationResolver = migrationResolver;
            this.schemaHistory = schemaHistory;
            this.database = database;
            this.defaultSchema = defaultSchema;
            this.schemas = schemas;
            this.callbackExecutor = callbackExecutor;
        }
    }
}

