/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline.driversupport;

import com.google.auto.service.AutoService;
import java.util.Properties;
import migratedb.v1.commandline.DriverSupport;

@AutoService(value={DriverSupport.class})
public class PostgreSQLDriverSupport
implements DriverSupport {
    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public boolean handlesJdbcUrl(String url) {
        return url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:p6spy:postgresql:");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:postgresql:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "org.postgresql.Driver";
    }

    @Override
    public void modifyDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("applicationName", "MigrateDB");
    }

    @Override
    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=");
    }

    @Override
    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("password=");
    }
}

