/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline.driversupport;

import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.regex.Pattern;
import migratedb.v1.commandline.DriverSupport;
import migratedb.v1.core.api.MigrateDbException;

@AutoService(value={DriverSupport.class})
public final class OracleDriverSupport
implements DriverSupport {
    private static final Pattern usernamePasswordPattern = Pattern.compile("^jdbc:oracle:thin:[a-zA-Z\\d#_$]+/([a-zA-Z\\d#_$]+)@.*");

    public static String getStaticFieldValue(String className, String fieldName, ClassLoader classLoader) {
        try {
            return OracleDriverSupport.getStaticFieldValue(Class.forName(className, true, classLoader), fieldName);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new MigrateDbException("Unable to obtain field value " + className + "." + fieldName + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getStaticFieldValue(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new MigrateDbException("Unable to obtain field value " + clazz.getName() + "." + fieldName + " : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public boolean detectUserRequiredByUrl(String url) {
        return !usernamePasswordPattern.matcher(url).matches();
    }

    @Override
    public boolean detectPasswordRequiredByUrl(String url) {
        return !usernamePasswordPattern.matcher(url).matches();
    }

    @Override
    public void modifyDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        String osUser = System.getProperty("user.name");
        props.put("v$session.osuser", osUser.substring(0, Math.min(osUser.length(), 30)));
        props.put("v$session.program", "MigrateDB");
        props.put("oracle.net.keepAlive", "true");
        String oobb = OracleDriverSupport.getStaticFieldValue("oracle.jdbc.OracleConnection", "CONNECTION_PROPERTY_THIN_NET_DISABLE_OUT_OF_BAND_BREAK", classLoader);
        props.put(oobb, "true");
    }

    @Override
    public boolean handlesJdbcUrl(String url) {
        return url.startsWith("jdbc:oracle") || url.startsWith("jdbc:p6spy:oracle");
    }

    @Override
    public Pattern getJdbcCredentialsPattern() {
        return usernamePasswordPattern;
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:oracle:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "oracle.jdbc.OracleDriver";
    }
}

