/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.io.PrintStream;
import java.util.ArrayList;
import migratedb.v1.commandline.Arguments;
import migratedb.v1.commandline.ConsoleLogSystem;
import migratedb.v1.commandline.DiscardingPrintStream;
import migratedb.v1.commandline.FileLogSystem;
import migratedb.v1.commandline.MigrateDbCommand;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.internal.logging.MultiLogSystem;
import migratedb.v1.core.internal.logging.NoLogSystem;

public class Main {
    public static void main(String[] args) {
        int exitCode;
        Arguments arguments = new Arguments(args);
        PrintStream realStdOut = System.out;
        PrintStream realStdErr = System.err;
        if (arguments.shouldOutputJson()) {
            System.setOut(new DiscardingPrintStream());
            System.setErr(new DiscardingPrintStream());
        }
        Log.setDefaultLogSystem((LogSystem)Main.getDefaultLogSystem(arguments));
        try {
            exitCode = new MigrateDbCommand(arguments, System.console(), realStdOut, realStdErr, System.in, System.getenv()).run();
        }
        catch (Exception e) {
            exitCode = 2;
        }
        System.exit(exitCode);
    }

    private static LogSystem getDefaultLogSystem(Arguments arguments) {
        if (arguments.shouldOutputJson()) {
            return NoLogSystem.INSTANCE;
        }
        ArrayList<Object> logSystems = new ArrayList<Object>();
        logSystems.add(new ConsoleLogSystem(arguments, System.out, System.err));
        if (arguments.isOutputFileSet()) {
            logSystems.add(new FileLogSystem(arguments));
        }
        return new MultiLogSystem(logSystems);
    }
}

