/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import migratedb.v1.commandline.Arguments;
import migratedb.v1.commandline.LogLevel;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.logging.LogSystem;

public class FileLogSystem
implements LogSystem {
    private final LogLevel level;
    private final Path path;

    public FileLogSystem(Arguments commandLineArguments) {
        String outputFilepath = "";
        if (commandLineArguments.isOutputFileSet()) {
            outputFilepath = commandLineArguments.getOutputFile();
        }
        this.level = commandLineArguments.getLogLevel();
        this.path = Paths.get(outputFilepath, new String[0]);
        FileLogSystem.prepareOutputFile(this.path);
    }

    public boolean isDebugEnabled(String logName) {
        return this.level == LogLevel.DEBUG;
    }

    public void debug(String logName, String message) {
        if (this.isDebugEnabled(logName)) {
            this.writeLogMessage("DEBUG", message);
        }
    }

    public void info(String logName, String message) {
        if (this.level.compareTo(LogLevel.INFO) <= 0) {
            this.writeLogMessage(message);
        }
    }

    public void warn(String logName, String message) {
        this.writeLogMessage("WARNING", message);
    }

    public void error(String logName, String message) {
        this.writeLogMessage("ERROR", message);
    }

    public void error(String logName, String message, Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        this.writeLogMessage("ERROR", message);
        this.writeLogMessage(stackTrace);
    }

    private void writeLogMessage(String prefix, String message) {
        String logMessage = prefix + ": " + message;
        this.writeLogMessage(logMessage);
    }

    private void writeLogMessage(String logMessage) {
        try {
            Files.write(this.path, (logMessage + "\n").getBytes(Charset.defaultCharset()), StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException exception) {
            throw new MigrateDbException("Could not write to file at " + this.path + ".", (Throwable)exception);
        }
    }

    private static void prepareOutputFile(Path path) {
        try {
            Files.write(path, "".getBytes(Charset.defaultCharset()), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException exception) {
            throw new MigrateDbException("Could not initialize log file at " + path + ".", (Throwable)exception);
        }
    }
}

