/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import migratedb.v1.commandline.DriverSupport;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.util.StringUtils;

public final class DriverSupportRegistry {
    private static final Log LOG = Log.getLog(DriverSupportRegistry.class);
    private final List<DriverSupport> driverSupportList = new ArrayList<DriverSupport>();

    public void register(DriverSupport driverSupport) {
        this.driverSupportList.add(driverSupport);
    }

    public DriverSupport getDriverSupportForUrl(String url) {
        List<DriverSupport> driversAcceptingUrl = this.getAllDriverSupportForUrl(url);
        if (!driversAcceptingUrl.isEmpty()) {
            if (driversAcceptingUrl.size() > 1) {
                StringBuilder builder = new StringBuilder();
                for (DriverSupport type : driversAcceptingUrl) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(type.getName());
                }
                LOG.debug("Multiple databases found that handle url '" + this.redactJdbcUrl(url) + "': " + builder);
            }
            return driversAcceptingUrl.get(0);
        }
        throw new MigrateDbException("No database found to handle " + this.redactJdbcUrl(url));
    }

    private List<DriverSupport> getAllDriverSupportForUrl(String url) {
        ArrayList<DriverSupport> support = new ArrayList<DriverSupport>();
        for (DriverSupport driverSupport : this.driverSupportList) {
            if (!driverSupport.handlesJdbcUrl(url)) continue;
            support.add(driverSupport);
        }
        return support;
    }

    public String redactJdbcUrl(String url) {
        List<DriverSupport> allDriverSupport = this.getAllDriverSupportForUrl(url);
        if (allDriverSupport.isEmpty()) {
            url = this.redactJdbcUrl(url, DriverSupport.defaultJdbcCredentialsPattern);
        } else {
            for (DriverSupport driverSupport : allDriverSupport) {
                Pattern dbPattern = driverSupport.getJdbcCredentialsPattern();
                url = this.redactJdbcUrl(url, dbPattern);
            }
        }
        return url;
    }

    private String redactJdbcUrl(String url, Pattern pattern) {
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String password = matcher.group(1);
            return url.replace(password, StringUtils.trimOrPad((String)"", (int)password.length(), (char)'*'));
        }
        return url;
    }
}

