/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import migratedb.v1.commandline.DriverSupport;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.internal.util.ClassUtils;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DriverSupportDataSource
implements ConnectionProvider {
    private Driver driver;
    private final String url;
    private final String user;
    private final String password;
    private final Properties properties;
    private final DriverSupport driverSupport;

    public DriverSupportDataSource(ClassLoader classLoader, @Nullable String driverClass, String url, @Nullable String user, @Nullable String password, Map<String, String> properties, DriverSupport driverSupport) throws MigrateDbException {
        this.url = Objects.requireNonNull(url);
        this.driverSupport = Objects.requireNonNull(driverSupport);
        if (!StringUtils.hasLength((String)driverClass)) {
            driverClass = driverSupport.getDriverClass(url, classLoader);
        }
        this.properties = new Properties();
        properties.forEach(this.properties::setProperty);
        try {
            this.driver = (Driver)ClassUtils.instantiate((String)driverClass, (ClassLoader)classLoader);
        }
        catch (MigrateDbException e) {
            String backupDriverClass = driverSupport.getBackupDriverClass(url, classLoader);
            if (backupDriverClass == null) {
                Object extendedError = driverSupport.instantiateClassExtendedErrorMessage();
                if (StringUtils.hasText((String)extendedError)) {
                    extendedError = "\n" + (String)extendedError;
                }
                throw new MigrateDbException("Unable to instantiate JDBC driver: " + driverClass + " => Check whether the jar file is present" + (String)extendedError, (Throwable)e, ErrorCode.JDBC_DRIVER);
            }
            try {
                this.driver = (Driver)ClassUtils.instantiate((String)backupDriverClass, (ClassLoader)classLoader);
            }
            catch (RuntimeException e1) {
                throw new MigrateDbException("Unable to instantiate JDBC driver: " + driverClass + " or backup driver: " + backupDriverClass + " => Check whether the jar file is present", (Throwable)e, ErrorCode.JDBC_DRIVER);
            }
        }
        this.user = user;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.user, this.password);
    }

    private Connection getConnectionFromDriver(@Nullable String username, @Nullable String password) throws SQLException {
        Connection connection;
        Properties properties = new Properties(this.properties);
        if (username != null) {
            properties.setProperty("user", username);
        }
        if (password != null) {
            properties.setProperty("password", password);
        }
        if ((connection = this.driver.connect(this.url, properties)) == null) {
            throw new MigrateDbException("Unable to connect to " + this.driverSupport.redactJdbcUrl(this.url));
        }
        connection.setAutoCommit(true);
        return connection;
    }
}

